/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieErrorTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.streamer.BaseErrorTableWriter;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;

public final class ErrorTableUtils {
    public static Option<BaseErrorTableWriter> getErrorTableWriter(HoodieStreamer.Config cfg, SparkSession sparkSession, TypedProperties props, HoodieSparkEngineContext hoodieSparkContext, FileSystem fs, Option<HoodieIngestionMetrics> metrics) {
        String errorTableWriterClass = props.getString(HoodieErrorTableConfig.ERROR_TABLE_WRITE_CLASS.key());
        ValidationUtils.checkState(!StringUtils.isNullOrEmpty(errorTableWriterClass), "Missing error table config " + HoodieErrorTableConfig.ERROR_TABLE_WRITE_CLASS);
        Class[] legacyArgClass = new Class[]{HoodieStreamer.Config.class, SparkSession.class, TypedProperties.class, HoodieSparkEngineContext.class, FileSystem.class};
        Class[] argClass = new Class[]{HoodieStreamer.Config.class, SparkSession.class, TypedProperties.class, HoodieSparkEngineContext.class, FileSystem.class, Option.class};
        try {
            if (ReflectionUtils.hasConstructor(errorTableWriterClass, argClass)) {
                return Option.of((BaseErrorTableWriter)ReflectionUtils.getClass(errorTableWriterClass).getConstructor(argClass).newInstance(cfg, sparkSession, props, hoodieSparkContext, fs, metrics));
            }
            if (ReflectionUtils.hasConstructor(errorTableWriterClass, legacyArgClass)) {
                return Option.of((BaseErrorTableWriter)ReflectionUtils.getClass(errorTableWriterClass).getConstructor(legacyArgClass).newInstance(cfg, sparkSession, props, hoodieSparkContext, fs));
            }
            throw new HoodieException(String.format("The configured Error table class %s does not have the appropriate constructor", errorTableWriterClass));
        }
        catch (Exception exception) {
            throw new HoodieException("Could not load Error Table class " + BaseErrorTableWriter.class.getName(), exception);
        }
    }

    public static HoodieErrorTableConfig.ErrorWriteFailureStrategy getErrorWriteFailureStrategy(TypedProperties props) {
        String writeFailureStrategy = props.getString(HoodieErrorTableConfig.ERROR_TABLE_WRITE_FAILURE_STRATEGY.key(), HoodieErrorTableConfig.ERROR_TABLE_WRITE_FAILURE_STRATEGY.defaultValue());
        return HoodieErrorTableConfig.ErrorWriteFailureStrategy.valueOf(writeFailureStrategy);
    }

    public static void validate(Dataset<Row> dataset) {
        if (!ErrorTableUtils.isErrorTableCorruptRecordColumnPresent(dataset)) {
            throw new HoodieValidationException(String.format("Invalid condition, columnName=%s is not present in transformer output schema", BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME));
        }
    }

    public static Dataset<Row> addNullValueErrorTableCorruptRecordColumn(Dataset<Row> dataset) {
        if (!ErrorTableUtils.isErrorTableCorruptRecordColumnPresent(dataset)) {
            dataset = dataset.withColumn(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME, functions.lit(null));
        }
        return dataset;
    }

    private static boolean isErrorTableCorruptRecordColumnPresent(Dataset<Row> dataset) {
        return Arrays.stream(dataset.columns()).anyMatch(col -> col.equals(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME));
    }
}

