/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;

@InterfaceStability.Evolving
public class DescribeUserScramCredentialsResult {
    private final KafkaFuture<DescribeUserScramCredentialsResponseData> dataFuture;

    DescribeUserScramCredentialsResult(KafkaFuture<DescribeUserScramCredentialsResponseData> dataFuture) {
        this.dataFuture = Objects.requireNonNull(dataFuture);
    }

    public KafkaFuture<Map<String, UserScramCredentialsDescription>> all() {
        KafkaFutureImpl<Map<String, UserScramCredentialsDescription>> retval = new KafkaFutureImpl<Map<String, UserScramCredentialsDescription>>();
        this.dataFuture.whenComplete((data2, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                Optional<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> optionalFirstFailedDescribe = data2.results().stream().filter(result2 -> result2.errorCode() != Errors.NONE.code() && result2.errorCode() != Errors.RESOURCE_NOT_FOUND.code()).findFirst();
                if (optionalFirstFailedDescribe.isPresent()) {
                    retval.completeExceptionally(Errors.forCode(optionalFirstFailedDescribe.get().errorCode()).exception(optionalFirstFailedDescribe.get().errorMessage()));
                } else {
                    HashMap retvalMap = new HashMap();
                    data2.results().stream().forEach(userResult -> retvalMap.put(userResult.user(), new UserScramCredentialsDescription(userResult.user(), DescribeUserScramCredentialsResult.getScramCredentialInfosFor(userResult))));
                    retval.complete(retvalMap);
                }
            }
        });
        return retval;
    }

    public KafkaFuture<List<String>> users() {
        KafkaFutureImpl<List<String>> retval = new KafkaFutureImpl<List<String>>();
        this.dataFuture.whenComplete((data2, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                retval.complete(data2.results().stream().filter(result2 -> result2.errorCode() != Errors.RESOURCE_NOT_FOUND.code()).map(result2 -> result2.user()).collect(Collectors.toList()));
            }
        });
        return retval;
    }

    public KafkaFuture<UserScramCredentialsDescription> description(String userName) {
        KafkaFutureImpl<UserScramCredentialsDescription> retval = new KafkaFutureImpl<UserScramCredentialsDescription>();
        this.dataFuture.whenComplete((data2, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                Optional<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> optionalUserResult = data2.results().stream().filter(result2 -> result2.user().equals(userName)).findFirst();
                if (!optionalUserResult.isPresent()) {
                    retval.completeExceptionally(new ResourceNotFoundException("No such user: " + userName));
                } else {
                    DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult userResult = optionalUserResult.get();
                    if (userResult.errorCode() != Errors.NONE.code()) {
                        retval.completeExceptionally(Errors.forCode(userResult.errorCode()).exception(userResult.errorMessage()));
                    } else {
                        retval.complete(new UserScramCredentialsDescription(userResult.user(), DescribeUserScramCredentialsResult.getScramCredentialInfosFor(userResult)));
                    }
                }
            }
        });
        return retval;
    }

    private static List<ScramCredentialInfo> getScramCredentialInfosFor(DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult userResult) {
        return userResult.credentialInfos().stream().map(c -> new ScramCredentialInfo(ScramMechanism.fromType(c.mechanism()), c.iterations())).collect(Collectors.toList());
    }
}

