/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class RemoveMembersFromConsumerGroupOptions
extends AbstractOptions<RemoveMembersFromConsumerGroupOptions> {
    private Set<MemberToRemove> members;
    private String reason;

    public RemoveMembersFromConsumerGroupOptions(Collection<MemberToRemove> members2) {
        if (members2.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty members has been provided");
        }
        this.members = new HashSet<MemberToRemove>(members2);
    }

    public RemoveMembersFromConsumerGroupOptions() {
        this.members = Collections.emptySet();
    }

    public void reason(String reason) {
        this.reason = reason;
    }

    public Set<MemberToRemove> members() {
        return this.members;
    }

    public String reason() {
        return this.reason;
    }

    public boolean removeAll() {
        return this.members.isEmpty();
    }
}

