/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;

public enum ScramMechanism {
    UNKNOWN(0),
    SCRAM_SHA_256(1),
    SCRAM_SHA_512(2);

    private static final ScramMechanism[] VALUES;
    private final byte type;
    private final String mechanismName;

    public static ScramMechanism fromType(byte type2) {
        for (ScramMechanism scramMechanism : VALUES) {
            if (scramMechanism.type != type2) continue;
            return scramMechanism;
        }
        return UNKNOWN;
    }

    public static ScramMechanism fromMechanismName(String mechanismName) {
        return Arrays.stream(VALUES).filter(mechanism -> mechanism.mechanismName.equals(mechanismName)).findFirst().orElse(UNKNOWN);
    }

    public String mechanismName() {
        return this.mechanismName;
    }

    public byte type() {
        return this.type;
    }

    private ScramMechanism(byte type2) {
        this.type = type2;
        this.mechanismName = this.toString().replace('_', '-');
    }

    static {
        VALUES = ScramMechanism.values();
    }
}

