/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public interface AdminApiFuture<K, V> {
    public Set<K> lookupKeys();

    public void complete(Map<K, V> var1);

    default public void completeLookup(Map<K, Integer> brokerIdMapping) {
    }

    default public void completeLookupExceptionally(Map<K, Throwable> lookupErrors) {
        this.completeExceptionally(lookupErrors);
    }

    public void completeExceptionally(Map<K, Throwable> var1);

    public static <K, V> SimpleAdminApiFuture<K, V> forKeys(Set<K> keys2) {
        return new SimpleAdminApiFuture(keys2);
    }

    public static class SimpleAdminApiFuture<K, V>
    implements AdminApiFuture<K, V> {
        private final Map<K, KafkaFuture<V>> futures;

        public SimpleAdminApiFuture(Set<K> keys2) {
            this.futures = keys2.stream().collect(Collectors.toMap(Function.identity(), k -> new KafkaFutureImpl()));
        }

        @Override
        public Set<K> lookupKeys() {
            return this.futures.keySet();
        }

        @Override
        public void complete(Map<K, V> values2) {
            values2.forEach(this::complete);
        }

        private void complete(K key, V value) {
            this.futureOrThrow(key).complete(value);
        }

        @Override
        public void completeExceptionally(Map<K, Throwable> errors2) {
            errors2.forEach(this::completeExceptionally);
        }

        private void completeExceptionally(K key, Throwable t) {
            this.futureOrThrow(key).completeExceptionally(t);
        }

        private KafkaFutureImpl<V> futureOrThrow(K key) {
            KafkaFutureImpl future = (KafkaFutureImpl)this.futures.get(key);
            if (future == null) {
                throw new IllegalArgumentException("Attempt to complete future for " + key + ", which was not requested");
            }
            return future;
        }

        public Map<K, KafkaFuture<V>> all() {
            return this.futures;
        }

        public KafkaFuture<V> get(K key) {
            return this.futures.get(key);
        }
    }
}

