/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

final class Utils {
    Utils() {
    }

    static final class TopicPartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;

        TopicPartitionComparator() {
        }

        @Override
        public int compare(TopicPartition topicPartition1, TopicPartition topicPartition2) {
            String topic2;
            String topic1 = topicPartition1.topic();
            if (topic1.equals(topic2 = topicPartition2.topic())) {
                return topicPartition1.partition() - topicPartition2.partition();
            }
            return topic1.compareTo(topic2);
        }
    }

    static final class PartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, List<String>> map;

        PartitionComparator(Map<String, List<String>> map2) {
            this.map = map2;
        }

        @Override
        public int compare(TopicPartition o1, TopicPartition o2) {
            int ret = this.map.get(o1.topic()).size() - this.map.get(o2.topic()).size();
            if (ret == 0 && (ret = o1.topic().compareTo(o2.topic())) == 0) {
                ret = o1.partition() - o2.partition();
            }
            return ret;
        }
    }
}

