/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.utils.Time;

public final class FutureRecordMetadata
implements Future<RecordMetadata> {
    private final ProduceRequestResult result;
    private final int batchIndex;
    private final long createTimestamp;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private final Time time;
    private volatile FutureRecordMetadata nextRecordMetadata = null;

    public FutureRecordMetadata(ProduceRequestResult result2, int batchIndex, long createTimestamp, int serializedKeySize, int serializedValueSize, Time time) {
        this.result = result2;
        this.batchIndex = batchIndex;
        this.createTimestamp = createTimestamp;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        this.time = time;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.result.await();
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.get();
        }
        return this.valueOrError();
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long now = this.time.milliseconds();
        long timeoutMillis = unit.toMillis(timeout);
        long deadline = Long.MAX_VALUE - timeoutMillis < now ? Long.MAX_VALUE : now + timeoutMillis;
        boolean occurred = this.result.await(timeout, unit);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + timeoutMillis + " ms.");
        }
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.get(deadline - this.time.milliseconds(), TimeUnit.MILLISECONDS);
        }
        return this.valueOrError();
    }

    void chain(FutureRecordMetadata futureRecordMetadata) {
        if (this.nextRecordMetadata == null) {
            this.nextRecordMetadata = futureRecordMetadata;
        } else {
            this.nextRecordMetadata.chain(futureRecordMetadata);
        }
    }

    RecordMetadata valueOrError() throws ExecutionException {
        RuntimeException exception = this.result.error(this.batchIndex);
        if (exception != null) {
            throw new ExecutionException(exception);
        }
        return this.value();
    }

    RecordMetadata value() {
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.value();
        }
        return new RecordMetadata(this.result.topicPartition(), this.result.baseOffset(), this.batchIndex, this.timestamp(), this.serializedKeySize, this.serializedValueSize);
    }

    private long timestamp() {
        return this.result.hasLogAppendTime() ? this.result.logAppendTime() : this.createTimestamp;
    }

    @Override
    public boolean isDone() {
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.isDone();
        }
        return this.result.completed();
    }
}

