/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterPartitionReassignmentsRequest
extends AbstractRequest {
    private final AlterPartitionReassignmentsRequestData data;

    private AlterPartitionReassignmentsRequest(AlterPartitionReassignmentsRequestData data2, short version) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, version);
        this.data = data2;
    }

    public static AlterPartitionReassignmentsRequest parse(ByteBuffer buffer, short version) {
        return new AlterPartitionReassignmentsRequest(new AlterPartitionReassignmentsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public AlterPartitionReassignmentsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse> topicResponses = new ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse>();
        for (AlterPartitionReassignmentsRequestData.ReassignableTopic topic : this.data.topics()) {
            List<AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse> partitionResponses = topic.partitions().stream().map(partition -> new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(partition.partitionIndex()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message())).collect(Collectors.toList());
            topicResponses.add(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName(topic.name()).setPartitions(partitionResponses));
        }
        AlterPartitionReassignmentsResponseData responseData = new AlterPartitionReassignmentsResponseData().setResponses(topicResponses).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new AlterPartitionReassignmentsResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterPartitionReassignmentsRequest> {
        private final AlterPartitionReassignmentsRequestData data;

        public Builder(AlterPartitionReassignmentsRequestData data2) {
            super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS);
            this.data = data2;
        }

        @Override
        public AlterPartitionReassignmentsRequest build(short version) {
            return new AlterPartitionReassignmentsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

