/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ControlledShutdownResponse
extends AbstractResponse {
    private final ControlledShutdownResponseData data;

    public ControlledShutdownResponse(ControlledShutdownResponseData data2) {
        super(ApiKeys.CONTROLLED_SHUTDOWN);
        this.data = data2;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownResponse(new ControlledShutdownResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public ControlledShutdownResponseData data() {
        return this.data;
    }

    public static ControlledShutdownResponse prepareResponse(Errors error, Set<TopicPartition> tps) {
        ControlledShutdownResponseData data2 = new ControlledShutdownResponseData();
        data2.setErrorCode(error.code());
        ControlledShutdownResponseData.RemainingPartitionCollection pSet = new ControlledShutdownResponseData.RemainingPartitionCollection();
        tps.forEach(tp -> pSet.add(new ControlledShutdownResponseData.RemainingPartition().setTopicName(tp.topic()).setPartitionIndex(tp.partition())));
        data2.setRemainingPartitions(pSet);
        return new ControlledShutdownResponse(data2);
    }
}

