/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;

public class DescribeClientQuotasRequest
extends AbstractRequest {
    public static final byte MATCH_TYPE_EXACT = 0;
    public static final byte MATCH_TYPE_DEFAULT = 1;
    public static final byte MATCH_TYPE_SPECIFIED = 2;
    private final DescribeClientQuotasRequestData data;

    public DescribeClientQuotasRequest(DescribeClientQuotasRequestData data2, short version) {
        super(ApiKeys.DESCRIBE_CLIENT_QUOTAS, version);
        this.data = data2;
    }

    public ClientQuotaFilter filter() {
        ArrayList<ClientQuotaFilterComponent> components = new ArrayList<ClientQuotaFilterComponent>(this.data.components().size());
        for (DescribeClientQuotasRequestData.ComponentData componentData : this.data.components()) {
            ClientQuotaFilterComponent component;
            switch (componentData.matchType()) {
                case 0: {
                    component = ClientQuotaFilterComponent.ofEntity(componentData.entityType(), componentData.match());
                    break;
                }
                case 1: {
                    component = ClientQuotaFilterComponent.ofDefaultEntity(componentData.entityType());
                    break;
                }
                case 2: {
                    component = ClientQuotaFilterComponent.ofEntityType(componentData.entityType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected match type: " + componentData.matchType());
                }
            }
            components.add(component);
        }
        if (this.data.strict()) {
            return ClientQuotaFilter.containsOnly(components);
        }
        return ClientQuotaFilter.contains(components);
    }

    @Override
    public DescribeClientQuotasRequestData data() {
        return this.data;
    }

    @Override
    public DescribeClientQuotasResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError error = ApiError.fromThrowable(e);
        return new DescribeClientQuotasResponse(new DescribeClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.error().code()).setErrorMessage(error.message()).setEntries(null));
    }

    public static DescribeClientQuotasRequest parse(ByteBuffer buffer, short version) {
        return new DescribeClientQuotasRequest(new DescribeClientQuotasRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeClientQuotasRequest> {
        private final DescribeClientQuotasRequestData data;

        public Builder(ClientQuotaFilter filter) {
            super(ApiKeys.DESCRIBE_CLIENT_QUOTAS);
            ArrayList<DescribeClientQuotasRequestData.ComponentData> componentData = new ArrayList<DescribeClientQuotasRequestData.ComponentData>(filter.components().size());
            for (ClientQuotaFilterComponent component : filter.components()) {
                DescribeClientQuotasRequestData.ComponentData fd = new DescribeClientQuotasRequestData.ComponentData().setEntityType(component.entityType());
                if (component.match() == null) {
                    fd.setMatchType((byte)2);
                    fd.setMatch(null);
                } else if (component.match().isPresent()) {
                    fd.setMatchType((byte)0);
                    fd.setMatch(component.match().get());
                } else {
                    fd.setMatchType((byte)1);
                    fd.setMatch(null);
                }
                componentData.add(fd);
            }
            this.data = new DescribeClientQuotasRequestData().setComponents(componentData).setStrict(filter.strict());
        }

        @Override
        public DescribeClientQuotasRequest build(short version) {
            return new DescribeClientQuotasRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

