/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;

public class DescribeConfigsRequest
extends AbstractRequest {
    private final DescribeConfigsRequestData data;

    public DescribeConfigsRequest(DescribeConfigsRequestData data2, short version) {
        super(ApiKeys.DESCRIBE_CONFIGS, version);
        this.data = data2;
    }

    @Override
    public DescribeConfigsRequestData data() {
        return this.data;
    }

    @Override
    public DescribeConfigsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new DescribeConfigsResponse(new DescribeConfigsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(this.data.resources().stream().map(result2 -> new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setResourceName(result2.resourceName()).setResourceType(result2.resourceType())).collect(Collectors.toList())));
    }

    public static DescribeConfigsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsRequest(new DescribeConfigsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeConfigsRequest> {
        private final DescribeConfigsRequestData data;

        public Builder(DescribeConfigsRequestData data2) {
            super(ApiKeys.DESCRIBE_CONFIGS);
            this.data = data2;
        }

        @Override
        public DescribeConfigsRequest build(short version) {
            return new DescribeConfigsRequest(this.data, version);
        }
    }
}

