/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;

public class OffsetCommitRequest
extends AbstractRequest {
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final OffsetCommitRequestData data;

    public OffsetCommitRequest(OffsetCommitRequestData data2, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.data = data2;
    }

    @Override
    public OffsetCommitRequestData data() {
        return this.data;
    }

    public Map<TopicPartition, Long> offsets() {
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic topic : this.data.topics()) {
            for (OffsetCommitRequestData.OffsetCommitRequestPartition partition : topic.partitions()) {
                offsets.put(new TopicPartition(topic.name(), partition.partitionIndex()), partition.committedOffset());
            }
        }
        return offsets;
    }

    public static List<OffsetCommitResponseData.OffsetCommitResponseTopic> getErrorResponseTopics(List<OffsetCommitRequestData.OffsetCommitRequestTopic> requestTopics, Errors e) {
        ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicData = new ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic entry : requestTopics) {
            ArrayList<OffsetCommitResponseData.OffsetCommitResponsePartition> responsePartitions = new ArrayList<OffsetCommitResponseData.OffsetCommitResponsePartition>();
            for (OffsetCommitRequestData.OffsetCommitRequestPartition requestPartition : entry.partitions()) {
                responsePartitions.add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(requestPartition.partitionIndex()).setErrorCode(e.code()));
            }
            responseTopicData.add(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(entry.name()).setPartitions(responsePartitions));
        }
        return responseTopicData;
    }

    @Override
    public OffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        List<OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicData = OffsetCommitRequest.getErrorResponseTopics(this.data.topics(), Errors.forException(e));
        return new OffsetCommitResponse(new OffsetCommitResponseData().setTopics(responseTopicData).setThrottleTimeMs(throttleTimeMs));
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, short version) {
        return new OffsetCommitRequest(new OffsetCommitRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final OffsetCommitRequestData data;

        public Builder(OffsetCommitRequestData data2) {
            super(ApiKeys.OFFSET_COMMIT);
            this.data = data2;
        }

        @Override
        public OffsetCommitRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 7) {
                throw new UnsupportedVersionException("The broker offset commit protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new OffsetCommitRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

