/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;

public class OffsetDeleteRequest
extends AbstractRequest {
    private final OffsetDeleteRequestData data;

    public OffsetDeleteRequest(OffsetDeleteRequestData data2, short version) {
        super(ApiKeys.OFFSET_DELETE, version);
        this.data = data2;
    }

    public AbstractResponse getErrorResponse(int throttleTimeMs, Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public static OffsetDeleteRequest parse(ByteBuffer buffer, short version) {
        return new OffsetDeleteRequest(new OffsetDeleteRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public OffsetDeleteRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetDeleteRequest> {
        private final OffsetDeleteRequestData data;

        public Builder(OffsetDeleteRequestData data2) {
            super(ApiKeys.OFFSET_DELETE);
            this.data = data2;
        }

        @Override
        public OffsetDeleteRequest build(short version) {
            return new OffsetDeleteRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

