/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;

public class UnregisterBrokerRequest
extends AbstractRequest {
    private final UnregisterBrokerRequestData data;

    public UnregisterBrokerRequest(UnregisterBrokerRequestData data2, short version) {
        super(ApiKeys.UNREGISTER_BROKER, version);
        this.data = data2;
    }

    @Override
    public UnregisterBrokerRequestData data() {
        return this.data;
    }

    @Override
    public UnregisterBrokerResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static UnregisterBrokerRequest parse(ByteBuffer buffer, short version) {
        return new UnregisterBrokerRequest(new UnregisterBrokerRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<UnregisterBrokerRequest> {
        private final UnregisterBrokerRequestData data;

        public Builder(UnregisterBrokerRequestData data2) {
            super(ApiKeys.UNREGISTER_BROKER);
            this.data = data2;
        }

        @Override
        public UnregisterBrokerRequest build(short version) {
            return new UnregisterBrokerRequest(this.data, version);
        }
    }
}

