/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class UnregisterBrokerResponse
extends AbstractResponse {
    private final UnregisterBrokerResponseData data;

    public UnregisterBrokerResponse(UnregisterBrokerResponseData data2) {
        super(ApiKeys.UNREGISTER_BROKER);
        this.data = data2;
    }

    @Override
    public UnregisterBrokerResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        if (this.data.errorCode() != 0) {
            errorCounts.put(Errors.forCode(this.data.errorCode()), 1);
        }
        return errorCounts;
    }

    public static UnregisterBrokerResponse parse(ByteBuffer buffer, short version) {
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }
}

