/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class VoteResponse
extends AbstractResponse {
    private final VoteResponseData data;

    public VoteResponse(VoteResponseData data2) {
        super(ApiKeys.VOTE);
        this.data = data2;
    }

    public static VoteResponseData singletonResponse(Errors topLevelError, TopicPartition topicPartition, Errors partitionLevelError, int leaderEpoch, int leaderId, boolean voteGranted) {
        return new VoteResponseData().setErrorCode(topLevelError.code()).setTopics(Collections.singletonList(new VoteResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new VoteResponseData.PartitionData().setErrorCode(partitionLevelError.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch).setVoteGranted(voteGranted)))));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors2 = new HashMap<Errors, Integer>();
        errors2.put(Errors.forCode(this.data.errorCode()), 1);
        for (VoteResponseData.TopicData topicResponse : this.data.topics()) {
            for (VoteResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                this.updateErrorCounts(errors2, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errors2;
    }

    @Override
    public VoteResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static VoteResponse parse(ByteBuffer buffer, short version) {
        return new VoteResponse(new VoteResponseData(new ByteBufferAccessor(buffer), version));
    }
}

