/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

public class ConfigurationUtils {
    private final Map<String, ?> configs;
    private final String prefix;

    public ConfigurationUtils(Map<String, ?> configs) {
        this(configs, null);
    }

    public ConfigurationUtils(Map<String, ?> configs, String saslMechanism) {
        this.configs = configs;
        this.prefix = saslMechanism != null && !saslMechanism.trim().isEmpty() ? ListenerName.saslMechanismPrefix(saslMechanism.trim()) : null;
    }

    public Path validateFile(String name2) {
        File file;
        URL url2 = this.validateUrl(name2);
        try {
            file = new File(url2.toURI().getRawPath()).getAbsoluteFile();
        }
        catch (URISyntaxException e) {
            throw new ConfigException(name2, url2.toString(), String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name2, url2, e.getMessage()));
        }
        if (!file.exists()) {
            throw new ConfigException(name2, file, String.format("The OAuth configuration option %s contains a file (%s) that doesn't exist", name2, file));
        }
        if (!file.canRead()) {
            throw new ConfigException(name2, file, String.format("The OAuth configuration option %s contains a file (%s) that doesn't have read permission", name2, file));
        }
        if (file.isDirectory()) {
            throw new ConfigException(name2, file, String.format("The OAuth configuration option %s references a directory (%s), not a file", name2, file));
        }
        return file.toPath();
    }

    public Integer validateInteger(String name2, boolean isRequired) {
        Integer value = (Integer)this.get(name2);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(name2, null, String.format("The OAuth configuration option %s must be non-null", name2));
            }
            return null;
        }
        return value;
    }

    public Long validateLong(String name2) {
        return this.validateLong(name2, true);
    }

    public Long validateLong(String name2, boolean isRequired) {
        return this.validateLong(name2, isRequired, null);
    }

    public Long validateLong(String name2, boolean isRequired, Long min) {
        Long value = (Long)this.get(name2);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(name2, null, String.format("The OAuth configuration option %s must be non-null", name2));
            }
            return null;
        }
        if (min != null && value < min) {
            throw new ConfigException(name2, value, String.format("The OAuth configuration option %s value must be at least %s", name2, min));
        }
        return value;
    }

    public URL validateUrl(String name2) {
        URL url2;
        String value = this.validateString(name2);
        try {
            url2 = new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(name2, value, String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name2, value, e.getMessage()));
        }
        String protocol = url2.getProtocol();
        if (protocol == null || protocol.trim().isEmpty()) {
            throw new ConfigException(name2, value, String.format("The OAuth configuration option %s contains a URL (%s) that is missing the protocol", name2, value));
        }
        if (!((protocol = protocol.toLowerCase(Locale.ROOT)).equals("http") || protocol.equals("https") || protocol.equals("file"))) {
            throw new ConfigException(name2, value, String.format("The OAuth configuration option %s contains a URL (%s) that contains an invalid protocol (%s); only \"http\", \"https\", and \"file\" protocol are supported", name2, value, protocol));
        }
        return url2;
    }

    public String validateString(String name2) throws ValidateException {
        return this.validateString(name2, true);
    }

    public String validateString(String name2, boolean isRequired) throws ValidateException {
        String value = (String)this.get(name2);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must be non-null", name2));
            }
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must not contain only whitespace", name2));
            }
            return null;
        }
        return value;
    }

    public <T> T get(String name2) {
        Object value = this.configs.get(this.prefix + name2);
        if (value != null) {
            return (T)value;
        }
        return (T)this.configs.get(name2);
    }
}

