/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class DoubleDeserializer
implements Deserializer<Double> {
    @Override
    public Double deserialize(String topic, byte[] data2) {
        if (data2 == null) {
            return null;
        }
        if (data2.length != 8) {
            throw new SerializationException("Size of data received by Deserializer is not 8");
        }
        long value = 0L;
        for (byte b : data2) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return Double.longBitsToDouble(value);
    }
}

