/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class FloatDeserializer
implements Deserializer<Float> {
    @Override
    public Float deserialize(String topic, byte[] data2) {
        if (data2 == null) {
            return null;
        }
        if (data2.length != 4) {
            throw new SerializationException("Size of data received by Deserializer is not 4");
        }
        int value = 0;
        for (byte b : data2) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value));
    }
}

