/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieCleaner {
    private static volatile Logger log = LogManager.getLogger(HoodieCleaner.class);
    private final Config cfg;
    private transient FileSystem fs;
    private transient JavaSparkContext jssc;
    private TypedProperties props;

    public HoodieCleaner(Config cfg, JavaSparkContext jssc) throws IOException {
        this.cfg = cfg;
        this.jssc = jssc;
        this.fs = FSUtils.getFs((String)cfg.basePath, (Configuration)jssc.hadoopConfiguration());
        this.props = cfg.propsFilePath == null ? UtilHelpers.buildProperties(cfg.configs) : UtilHelpers.readConfig(this.fs, new Path(cfg.propsFilePath), cfg.configs).getConfig();
        log.info((Object)("Creating Cleaner with configs : " + this.props.toString()));
    }

    public void run() throws Exception {
        HoodieWriteConfig hoodieCfg = this.getHoodieClientConfig();
        HoodieWriteClient client = new HoodieWriteClient(this.jssc, hoodieCfg, false);
        client.clean();
    }

    private HoodieWriteConfig getHoodieClientConfig() throws Exception {
        return HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(this.cfg.basePath).withAutoCommit(false).withProps((Map)this.props).build();
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        String dirName = new Path(cfg.basePath).getName();
        JavaSparkContext jssc = UtilHelpers.buildSparkContext("hoodie-cleaner-" + dirName, cfg.sparkMaster);
        new HoodieCleaner(cfg, jssc).run();
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--target-base-path"}, description="base path for the hoodie dataset to be cleaner.", required=true)
        public String basePath;
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for cleaning")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--propsFilePath\") can also be passed command line using this parameter")
        public List<String> configs = new ArrayList<String>();
        @Parameter(names={"--spark-master"}, description="spark master to use.")
        public String sparkMaster = "local[2]";
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }
}

