/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.javalin.Javalin;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class HoodieWithTimelineServer
implements Serializable {
    private final Config cfg;
    private transient Javalin app = null;

    public HoodieWithTimelineServer(Config cfg) {
        this.cfg = cfg;
    }

    public void startService() {
        this.app = Javalin.create().start(this.cfg.serverPort.intValue());
        this.app.get("/", ctx -> ctx.result("Hello World"));
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        HoodieWithTimelineServer service = new HoodieWithTimelineServer(cfg);
        service.run(UtilHelpers.buildSparkContext("client-server-hoodie", cfg.sparkMaster, cfg.sparkMemory));
    }

    public void run(JavaSparkContext jsc) throws UnknownHostException {
        this.startService();
        String driverHost = InetAddress.getLocalHost().getHostAddress();
        System.out.println("Driver Hostname is :" + driverHost);
        ArrayList messages = new ArrayList();
        IntStream.range(0, this.cfg.numPartitions).forEach(i -> messages.add("Hello World"));
        List gotMessages = jsc.parallelize(messages).map((Function & Serializable)msg -> this.sendRequest(driverHost, this.cfg.serverPort)).collect();
        System.out.println("Got Messages :" + gotMessages);
        Preconditions.checkArgument((boolean)gotMessages.equals(messages), (Object)"Got expected reply from Server");
    }

    /*
     * Exception decompiling
     */
    public String sendRequest(String driverHost, int port) throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--spark-master", "-ms"}, description="Spark master", required=false)
        public String sparkMaster = null;
        @Parameter(names={"--spark-memory", "-sm"}, description="spark memory to use", required=true)
        public String sparkMemory = null;
        @Parameter(names={"--num-partitions", "-n"}, description="Num Partitions", required=false)
        public Integer numPartitions = 100;
        @Parameter(names={"--server-port", "-p"}, description=" Server Port", required=false)
        public Integer serverPort = 26754;
        @Parameter(names={"--delay-secs", "-d"}, description="Delay(sec) before client connects", required=false)
        public Integer delaySecs = 30;
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }
}

