/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.util.DFSPropertiesConfiguration;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.compact.strategy.CompactionStrategy;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.Accumulator;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;

public class UtilHelpers {
    private static Logger logger = LogManager.getLogger(UtilHelpers.class);

    public static Source createSource(String sourceClass, TypedProperties cfg, JavaSparkContext jssc, SparkSession sparkSession, SchemaProvider schemaProvider) throws IOException {
        try {
            return (Source)ReflectionUtils.loadClass((String)sourceClass, (Class[])new Class[]{TypedProperties.class, JavaSparkContext.class, SparkSession.class, SchemaProvider.class}, (Object[])new Object[]{cfg, jssc, sparkSession, schemaProvider});
        }
        catch (Throwable e) {
            throw new IOException("Could not load source class " + sourceClass, e);
        }
    }

    public static SchemaProvider createSchemaProvider(String schemaProviderClass, TypedProperties cfg, JavaSparkContext jssc) throws IOException {
        try {
            return schemaProviderClass == null ? null : (SchemaProvider)ReflectionUtils.loadClass((String)schemaProviderClass, (Object[])new Object[]{cfg, jssc});
        }
        catch (Throwable e) {
            throw new IOException("Could not load schema provider class " + schemaProviderClass, e);
        }
    }

    public static Transformer createTransformer(String transformerClass) throws IOException {
        try {
            return transformerClass == null ? null : (Transformer)ReflectionUtils.loadClass((String)transformerClass);
        }
        catch (Throwable e) {
            throw new IOException("Could not load transformer class " + transformerClass, e);
        }
    }

    public static DFSPropertiesConfiguration readConfig(FileSystem fs, Path cfgPath, List<String> overriddenProps) {
        try {
            DFSPropertiesConfiguration conf = new DFSPropertiesConfiguration(cfgPath.getFileSystem(fs.getConf()), cfgPath);
            if (!overriddenProps.isEmpty()) {
                logger.info((Object)"Adding overridden properties to file properties.");
                conf.addProperties(new BufferedReader(new StringReader(String.join((CharSequence)"\n", overriddenProps))));
            }
            return conf;
        }
        catch (Exception e) {
            throw new HoodieException("Unable to read props file at :" + cfgPath, (Throwable)e);
        }
    }

    public static TypedProperties buildProperties(List<String> props) {
        TypedProperties properties = new TypedProperties();
        props.stream().forEach(x -> {
            String[] kv = x.split("=");
            Preconditions.checkArgument((kv.length == 2 ? 1 : 0) != 0);
            properties.setProperty(kv[0], kv[1]);
        });
        return properties;
    }

    public static String parseSchema(FileSystem fs, String schemaFile) throws Exception {
        Path p = new Path(schemaFile);
        if (!fs.exists(p)) {
            throw new Exception(String.format("Could not find - %s - schema file.", schemaFile));
        }
        long len = fs.getFileStatus(p).getLen();
        ByteBuffer buf = ByteBuffer.allocate((int)len);
        try (FSDataInputStream inputStream = fs.open(p);){
            inputStream.readFully(0L, buf.array(), 0, buf.array().length);
        }
        return new String(buf.array());
    }

    private static SparkConf buildSparkConf(String appName, String defaultMaster) {
        return UtilHelpers.buildSparkConf(appName, defaultMaster, new HashMap<String, String>());
    }

    private static SparkConf buildSparkConf(String appName, String defaultMaster, Map<String, String> additionalConfigs) {
        SparkConf sparkConf = new SparkConf().setAppName(appName);
        String master = sparkConf.get("spark.master", defaultMaster);
        sparkConf.setMaster(master);
        if (master.startsWith("yarn")) {
            sparkConf.set("spark.eventLog.overwrite", "true");
            sparkConf.set("spark.eventLog.enabled", "true");
        }
        sparkConf.setIfMissing("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        additionalConfigs.entrySet().forEach(e -> sparkConf.set((String)e.getKey(), (String)e.getValue()));
        SparkConf newSparkConf = HoodieWriteClient.registerClasses((SparkConf)sparkConf);
        return newSparkConf;
    }

    public static JavaSparkContext buildSparkContext(String appName, String defaultMaster, Map<String, String> configs) {
        return new JavaSparkContext(UtilHelpers.buildSparkConf(appName, defaultMaster, configs));
    }

    public static JavaSparkContext buildSparkContext(String appName, String defaultMaster) {
        return new JavaSparkContext(UtilHelpers.buildSparkConf(appName, defaultMaster));
    }

    public static JavaSparkContext buildSparkContext(String appName, String sparkMaster, String sparkMemory) {
        SparkConf sparkConf = UtilHelpers.buildSparkConf(appName, sparkMaster);
        sparkConf.set("spark.executor.memory", sparkMemory);
        return new JavaSparkContext(sparkConf);
    }

    public static HoodieWriteClient createHoodieClient(JavaSparkContext jsc, String basePath, String schemaStr, int parallelism, Option<String> compactionStrategyClass, TypedProperties properties) throws Exception {
        HoodieCompactionConfig compactionConfig = (HoodieCompactionConfig)compactionStrategyClass.map(strategy -> HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).withCompactionStrategy((CompactionStrategy)ReflectionUtils.loadClass((String)strategy)).build()).orElse((Object)HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).build());
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(basePath).withParallelism(parallelism, parallelism).withSchema(schemaStr).combineInput(true, true).withCompactionConfig(compactionConfig).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withProps((Map)properties).build();
        return new HoodieWriteClient(jsc, config);
    }

    public static int handleErrors(JavaSparkContext jsc, String instantTime, JavaRDD<WriteStatus> writeResponse) {
        Accumulator errors = jsc.accumulator(0);
        writeResponse.foreach((VoidFunction & Serializable)writeStatus -> {
            if (writeStatus.hasErrors()) {
                errors.add((Object)1);
                logger.error((Object)String.format("Error processing records :writeStatus:%s", writeStatus.getStat().toString()));
            }
        });
        if ((Integer)errors.value() == 0) {
            logger.info((Object)String.format("Dataset imported into hoodie dataset with %s instant time.", instantTime));
            return 0;
        }
        logger.error((Object)String.format("Import failed with %d errors.", errors.value()));
        return -1;
    }

    public static TypedProperties readConfig(InputStream in) throws IOException {
        TypedProperties defaults = new TypedProperties();
        defaults.load(in);
        return defaults;
    }
}

