/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.adhoc;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.FSUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class UpgradePayloadFromUberToApache
implements Serializable {
    private static Logger logger = LogManager.getLogger(UpgradePayloadFromUberToApache.class);
    private final Config cfg;

    public UpgradePayloadFromUberToApache(Config cfg) {
        this.cfg = cfg;
    }

    public void run() throws IOException {
        String basePath = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.cfg.inputPath));){
            basePath = reader.readLine();
        }
        catch (IOException e) {
            logger.error((Object)("Read from path: " + this.cfg.inputPath + " error."), (Throwable)e);
        }
        while (basePath != null) {
            if ((basePath = basePath.trim()).startsWith("#")) continue;
            logger.info((Object)("Performing upgrade for " + basePath));
            String metaPath = String.format("%s/.hoodie", basePath);
            HoodieTableMetaClient metaClient = new HoodieTableMetaClient(FSUtils.prepareHadoopConf((Configuration)new Configuration()), basePath, false);
            HoodieTableConfig tableConfig = metaClient.getTableConfig();
            if (tableConfig.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
                Map propsMap = tableConfig.getProps();
                if (!propsMap.containsKey("hoodie.compaction.payload.class")) continue;
                String payloadClass = (String)propsMap.get("hoodie.compaction.payload.class");
                logger.info((Object)("Found payload class=" + payloadClass));
                if (!payloadClass.startsWith("com.uber.hoodie")) continue;
                String newPayloadClass = payloadClass.replace("com.uber.hoodie", "org.apache.hudi");
                logger.info((Object)("Replacing payload class (" + payloadClass + ") with (" + newPayloadClass + ")"));
                HashMap<String, String> newPropsMap = new HashMap<String, String>(propsMap);
                newPropsMap.put("hoodie.compaction.payload.class", newPayloadClass);
                Properties props = new Properties();
                props.putAll((Map<?, ?>)newPropsMap);
                HoodieTableConfig.createHoodieProperties((FileSystem)metaClient.getFs(), (Path)new Path(metaPath), (Properties)props);
                logger.info((Object)("Finished upgrade for " + basePath));
                continue;
            }
            logger.info((Object)("Skipping as this table is COW table. BasePath=" + basePath));
        }
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        UpgradePayloadFromUberToApache upgrader = new UpgradePayloadFromUberToApache(cfg);
        upgrader.run();
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--datasets_list_path", "-sp"}, description="Local File containing list of base-paths for which migration needs to be performed", required=true)
        public String inputPath = null;
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }
}

