/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractDeltaStreamerService
implements Serializable {
    protected static volatile Logger log = LogManager.getLogger(AbstractDeltaStreamerService.class);
    private boolean started;
    private boolean shutdownRequested = false;
    private volatile boolean shutdown;
    private transient ExecutorService executor;
    private transient CompletableFuture future;

    AbstractDeltaStreamerService() {
    }

    boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    void waitForShutdown() throws ExecutionException, InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException ex) {
            log.error((Object)"Service shutdown with error", (Throwable)ex);
            throw ex;
        }
    }

    void shutdown(boolean force) {
        if (!this.shutdownRequested || force) {
            this.shutdownRequested = true;
            if (this.executor != null) {
                if (force) {
                    this.executor.shutdownNow();
                } else {
                    this.executor.shutdown();
                    try {
                        this.executor.awaitTermination(24L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)"Interrupted while waiting for shutdown", (Throwable)ie);
                    }
                }
            }
        }
    }

    public void start(Function<Boolean, Boolean> onShutdownCallback) {
        Pair<CompletableFuture, ExecutorService> res = this.startService();
        this.future = (CompletableFuture)res.getKey();
        this.executor = (ExecutorService)res.getValue();
        this.started = true;
        this.monitorThreads(onShutdownCallback);
    }

    protected abstract Pair<CompletableFuture, ExecutorService> startService();

    private void monitorThreads(Function<Boolean, Boolean> onShutdownCallback) {
        log.info((Object)"Submitting monitor thread !!");
        Executors.newSingleThreadExecutor().submit(() -> {
            boolean error = false;
            try {
                log.info((Object)"Monitoring thread(s) !!");
                this.future.get();
            }
            catch (ExecutionException ex) {
                log.error((Object)"Monitor noticed one or more threads failed. Requesting graceful shutdown of other threads", (Throwable)ex);
                error = true;
                this.shutdown(false);
            }
            catch (InterruptedException ie) {
                log.error((Object)"Got interrupted Monitoring threads", (Throwable)ie);
                error = true;
                this.shutdown(false);
            }
            finally {
                this.shutdown = true;
                onShutdownCallback.apply(error);
            }
        });
    }
}

