/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class Compactor
implements Serializable {
    protected static volatile Logger log = LogManager.getLogger(Compactor.class);
    private transient HoodieWriteClient compactionClient;
    private transient JavaSparkContext jssc;

    public Compactor(HoodieWriteClient compactionClient, JavaSparkContext jssc) {
        this.jssc = jssc;
        this.compactionClient = compactionClient;
    }

    public void compact(HoodieInstant instant) throws IOException {
        log.info((Object)("Compactor executing compaction " + instant));
        JavaRDD res = this.compactionClient.compact(instant.getTimestamp());
        long numWriteErrors = res.collect().stream().filter(r -> r.hasErrors()).count();
        if (numWriteErrors != 0L) {
            log.error((Object)("Compaction for instant (" + instant + ") failed with write errors. Errors :" + numWriteErrors));
            throw new HoodieException("Compaction for instant (" + instant + ") failed with write errors. Errors :" + numWriteErrors);
        }
        this.compactionClient.commitCompaction(instant.getTimestamp(), res, Option.empty());
    }
}

