/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import com.codahale.metrics.Timer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;

public class HoodieDeltaStreamerMetrics {
    private HoodieWriteConfig config = null;
    private String tableName = null;
    public String overallTimerName = null;
    public String hiveSyncTimerName = null;
    private Timer overallTimer = null;
    public Timer hiveSyncTimer = null;

    public HoodieDeltaStreamerMetrics(HoodieWriteConfig config) {
        this.config = config;
        this.tableName = config.getTableName();
        if (config.isMetricsOn()) {
            Metrics.init((HoodieWriteConfig)config);
            this.overallTimerName = this.getMetricsName("timer", "deltastreamer");
            this.hiveSyncTimerName = this.getMetricsName("timer", "deltastreamerHiveSync");
        }
    }

    public Timer.Context getOverallTimerContext() {
        if (this.config.isMetricsOn() && this.overallTimer == null) {
            this.overallTimer = this.createTimer(this.overallTimerName);
        }
        return this.overallTimer == null ? null : this.overallTimer.time();
    }

    public Timer.Context getHiveSyncTimerContext() {
        if (this.config.isMetricsOn() && this.hiveSyncTimer == null) {
            this.hiveSyncTimer = this.createTimer(this.hiveSyncTimerName);
        }
        return this.hiveSyncTimer == null ? null : this.hiveSyncTimer.time();
    }

    private Timer createTimer(String name) {
        return this.config.isMetricsOn() ? Metrics.getInstance().getRegistry().timer(name) : null;
    }

    String getMetricsName(String action, String metric) {
        return this.config == null ? null : String.format("%s.%s.%s", this.tableName, action, metric);
    }

    public void updateDeltaStreamerMetrics(long durationInNs, long hiveSyncNs) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge((String)this.getMetricsName("deltastreamer", "duration"), (long)this.getDurationInMs(durationInNs));
            Metrics.registerGauge((String)this.getMetricsName("deltastreamer", "hiveSyncDuration"), (long)this.getDurationInMs(hiveSyncNs));
        }
    }

    public long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }
}

