/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.sources.AvroSource;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.JsonSource;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.AvroConvertor;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public final class SourceFormatAdapter {
    private final Source source;

    public SourceFormatAdapter(Source source) {
        this.source = source;
    }

    public InputBatch<JavaRDD<GenericRecord>> fetchNewDataInAvroFormat(Option<String> lastCkptStr, long sourceLimit) {
        switch (this.source.getSourceType()) {
            case AVRO: {
                return ((AvroSource)this.source).fetchNext(lastCkptStr, sourceLimit);
            }
            case JSON: {
                InputBatch r = ((JsonSource)this.source).fetchNext(lastCkptStr, sourceLimit);
                AvroConvertor convertor = new AvroConvertor(r.getSchemaProvider().getSourceSchema());
                return new InputBatch<JavaRDD<GenericRecord>>(Option.ofNullable((Object)r.getBatch().map(rdd -> rdd.map(convertor::fromJson)).orElse(null)), r.getCheckpointForNextBatch(), r.getSchemaProvider());
            }
            case ROW: {
                InputBatch r = ((RowSource)this.source).fetchNext(lastCkptStr, sourceLimit);
                return new InputBatch<JavaRDD<GenericRecord>>(Option.ofNullable((Object)r.getBatch().map(rdd -> AvroConversionUtils.createRdd((Dataset)rdd, (String)"hoodie_source", (String)"hoodie.source").toJavaRDD()).orElse(null)), r.getCheckpointForNextBatch(), r.getSchemaProvider());
            }
        }
        throw new IllegalArgumentException("Unknown source type (" + (Object)((Object)this.source.getSourceType()) + ")");
    }

    public InputBatch<Dataset<Row>> fetchNewDataInRowFormat(Option<String> lastCkptStr, long sourceLimit) {
        switch (this.source.getSourceType()) {
            case ROW: {
                return ((RowSource)this.source).fetchNext(lastCkptStr, sourceLimit);
            }
            case AVRO: {
                InputBatch r = ((AvroSource)this.source).fetchNext(lastCkptStr, sourceLimit);
                Schema sourceSchema = r.getSchemaProvider().getSourceSchema();
                return new InputBatch<Dataset<Row>>(Option.ofNullable((Object)r.getBatch().map(rdd -> AvroConversionUtils.createDataFrame((RDD)JavaRDD.toRDD((JavaRDD)rdd), (String)sourceSchema.toString(), (SparkSession)this.source.getSparkSession())).orElse(null)), r.getCheckpointForNextBatch(), r.getSchemaProvider());
            }
            case JSON: {
                InputBatch r = ((JsonSource)this.source).fetchNext(lastCkptStr, sourceLimit);
                Schema sourceSchema = r.getSchemaProvider().getSourceSchema();
                StructType dataType = AvroConversionUtils.convertAvroSchemaToStructType((Schema)sourceSchema);
                return new InputBatch<Dataset<Row>>(Option.ofNullable((Object)r.getBatch().map(rdd -> this.source.getSparkSession().read().schema(dataType).json(rdd)).orElse(null)), r.getCheckpointForNextBatch(), r.getSchemaProvider());
            }
        }
        throw new IllegalArgumentException("Unknown source type (" + (Object)((Object)this.source.getSourceType()) + ")");
    }
}

