/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.keygen;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.SimpleKeyGenerator;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.utilities.exception.HoodieDeltaStreamerException;

public class TimestampBasedKeyGenerator
extends SimpleKeyGenerator {
    private final TimestampType timestampType;
    private SimpleDateFormat inputDateFormat;
    private final String outputDateFormat;

    public TimestampBasedKeyGenerator(TypedProperties config) {
        super(config);
        DataSourceUtils.checkRequiredProperties((TypedProperties)config, Arrays.asList("hoodie.deltastreamer.keygen.timebased.timestamp.type", "hoodie.deltastreamer.keygen.timebased.output.dateformat"));
        this.timestampType = TimestampType.valueOf(config.getString("hoodie.deltastreamer.keygen.timebased.timestamp.type"));
        this.outputDateFormat = config.getString("hoodie.deltastreamer.keygen.timebased.output.dateformat");
        if (this.timestampType == TimestampType.DATE_STRING || this.timestampType == TimestampType.MIXED) {
            DataSourceUtils.checkRequiredProperties((TypedProperties)config, Collections.singletonList("hoodie.deltastreamer.keygen.timebased.input.dateformat"));
            this.inputDateFormat = new SimpleDateFormat(config.getString("hoodie.deltastreamer.keygen.timebased.input.dateformat"));
            this.inputDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    public HoodieKey getKey(GenericRecord record) {
        Object partitionVal = DataSourceUtils.getNestedFieldVal((GenericRecord)record, (String)this.partitionPathField);
        SimpleDateFormat partitionPathFormat = new SimpleDateFormat(this.outputDateFormat);
        partitionPathFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            long unixTime;
            if (partitionVal instanceof Double) {
                unixTime = ((Double)partitionVal).longValue();
            } else if (partitionVal instanceof Float) {
                unixTime = ((Float)partitionVal).longValue();
            } else if (partitionVal instanceof Long) {
                unixTime = (Long)partitionVal;
            } else if (partitionVal instanceof String) {
                unixTime = this.inputDateFormat.parse(partitionVal.toString()).getTime() / 1000L;
            } else {
                throw new HoodieNotSupportedException("Unexpected type for partition field: " + partitionVal.getClass().getName());
            }
            return new HoodieKey(DataSourceUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.recordKeyField), partitionPathFormat.format(new Date(unixTime * 1000L)));
        }
        catch (ParseException pe) {
            throw new HoodieDeltaStreamerException("Unable to parse input partition field :" + partitionVal, pe);
        }
    }

    static class Config {
        private static final String TIMESTAMP_TYPE_FIELD_PROP = "hoodie.deltastreamer.keygen.timebased.timestamp.type";
        private static final String TIMESTAMP_INPUT_DATE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.input.dateformat";
        private static final String TIMESTAMP_OUTPUT_DATE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.output.dateformat";

        Config() {
        }
    }

    static enum TimestampType implements Serializable
    {
        UNIX_TIMESTAMP,
        DATE_STRING,
        MIXED;

    }
}

