/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class SchemaRegistryProvider
extends SchemaProvider {
    private final Schema schema;
    private final Schema targetSchema;

    private static String fetchSchemaFromRegistry(String registryUrl) throws IOException {
        URL registry = new URL(registryUrl);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(registry.openStream());
        return node.get("schema").asText();
    }

    public SchemaRegistryProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        DataSourceUtils.checkRequiredProperties((TypedProperties)props, Collections.singletonList("hoodie.deltastreamer.schemaprovider.registry.url"));
        String registryUrl = props.getString("hoodie.deltastreamer.schemaprovider.registry.url");
        String targetRegistryUrl = props.getString("hoodie.deltastreamer.schemaprovider.registry.targetUrl", registryUrl);
        try {
            this.schema = SchemaRegistryProvider.getSchema(registryUrl);
            this.targetSchema = !targetRegistryUrl.equals(registryUrl) ? SchemaRegistryProvider.getSchema(targetRegistryUrl) : this.schema;
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema from registry :" + registryUrl, ioe);
        }
    }

    private static Schema getSchema(String registryUrl) throws IOException {
        return new Schema.Parser().parse(SchemaRegistryProvider.fetchSchemaFromRegistry(registryUrl));
    }

    @Override
    public Schema getSourceSchema() {
        return this.schema;
    }

    @Override
    public Schema getTargetSchema() {
        return this.targetSchema;
    }

    public static class Config {
        private static final String SRC_SCHEMA_REGISTRY_URL_PROP = "hoodie.deltastreamer.schemaprovider.registry.url";
        private static final String TARGET_SCHEMA_REGISTRY_URL_PROP = "hoodie.deltastreamer.schemaprovider.registry.targetUrl";
    }
}

