/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.AvroSource;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;

public class AvroDFSSource
extends AvroSource {
    private final DFSPathSelector pathSelector;

    public AvroDFSSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.pathSelector = new DFSPathSelector(props, sparkContext.hadoopConfiguration());
    }

    @Override
    protected InputBatch<JavaRDD<GenericRecord>> fetchNewData(Option<String> lastCkptStr, long sourceLimit) {
        Pair<Option<String>, String> selectPathsWithMaxModificationTime = this.pathSelector.getNextFilePathsAndMaxModificationTime(lastCkptStr, sourceLimit);
        return (InputBatch)((Option)selectPathsWithMaxModificationTime.getLeft()).map(pathStr -> new InputBatch(Option.of(this.fromFiles((String)pathStr)), (String)selectPathsWithMaxModificationTime.getRight())).orElseGet(() -> new InputBatch(Option.empty(), (String)selectPathsWithMaxModificationTime.getRight()));
    }

    private JavaRDD<GenericRecord> fromFiles(String pathStr) {
        JavaPairRDD avroRDD = this.sparkContext.newAPIHadoopFile(pathStr, AvroKeyInputFormat.class, AvroKey.class, NullWritable.class, this.sparkContext.hadoopConfiguration());
        return avroRDD.keys().map((Function & Serializable)r -> (GenericRecord)r.datum());
    }
}

