/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import io.confluent.kafka.serializers.KafkaAvroDecoder;
import java.io.Serializable;
import kafka.serializer.StringDecoder;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.AvroSource;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka.KafkaUtils;
import org.apache.spark.streaming.kafka.OffsetRange;

public class AvroKafkaSource
extends AvroSource {
    private static Logger log = LogManager.getLogger(AvroKafkaSource.class);
    private final KafkaOffsetGen offsetGen;

    public AvroKafkaSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.offsetGen = new KafkaOffsetGen(props);
    }

    @Override
    protected InputBatch<JavaRDD<GenericRecord>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        OffsetRange[] offsetRanges = this.offsetGen.getNextOffsetRanges(lastCheckpointStr, sourceLimit);
        long totalNewMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages(offsetRanges);
        if (totalNewMsgs <= 0L) {
            return new InputBatch<JavaRDD<GenericRecord>>(Option.empty(), lastCheckpointStr.isPresent() ? (String)lastCheckpointStr.get() : "");
        }
        log.info((Object)("About to read " + totalNewMsgs + " from Kafka for topic :" + this.offsetGen.getTopicName()));
        JavaRDD<GenericRecord> newDataRDD = this.toRDD(offsetRanges);
        return new InputBatch<JavaRDD<GenericRecord>>(Option.of(newDataRDD), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
    }

    private JavaRDD<GenericRecord> toRDD(OffsetRange[] offsetRanges) {
        JavaRDD recordRDD = KafkaUtils.createRDD((JavaSparkContext)this.sparkContext, String.class, Object.class, StringDecoder.class, KafkaAvroDecoder.class, this.offsetGen.getKafkaParams(), (OffsetRange[])offsetRanges).values().map((Function & Serializable)obj -> (GenericRecord)obj);
        return recordRDD;
    }
}

