/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Arrays;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class HoodieIncrSource
extends RowSource {
    public HoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        DataSourceUtils.checkRequiredProperties((TypedProperties)this.props, Arrays.asList("hoodie.deltastreamer.source.hoodieincr.path"));
        String srcPath = this.props.getString("hoodie.deltastreamer.source.hoodieincr.path");
        int numInstantsPerFetch = this.props.getInteger("hoodie.deltastreamer.source.hoodieincr.num_instants", Config.DEFAULT_NUM_INSTANTS_PER_FETCH.intValue());
        boolean readLatestOnMissingCkpt = this.props.getBoolean("hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt", Config.DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT.booleanValue());
        Option<String> beginInstant = lastCkptStr.isPresent() ? (((String)lastCkptStr.get()).isEmpty() ? Option.empty() : lastCkptStr) : Option.empty();
        Pair<String, String> instantEndpts = IncrSourceHelper.calculateBeginAndEndInstants(this.sparkContext, srcPath, numInstantsPerFetch, beginInstant, readLatestOnMissingCkpt);
        if (((String)instantEndpts.getKey()).equals(instantEndpts.getValue())) {
            log.warn((Object)("Already caught up. Begin Checkpoint was :" + (String)instantEndpts.getKey()));
            return Pair.of((Object)Option.empty(), (Object)instantEndpts.getKey());
        }
        DataFrameReader reader = this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.VIEW_TYPE_OPT_KEY(), DataSourceReadOptions.VIEW_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME_OPT_KEY(), (String)instantEndpts.getLeft()).option(DataSourceReadOptions.END_INSTANTTIME_OPT_KEY(), (String)instantEndpts.getRight());
        Dataset source = reader.load(srcPath);
        Dataset src = source.drop((String[])HoodieRecord.HOODIE_META_COLUMNS.stream().filter(x -> !x.equals(HoodieRecord.PARTITION_PATH_METADATA_FIELD)).toArray(String[]::new));
        return Pair.of((Object)Option.of((Object)src), (Object)instantEndpts.getRight());
    }

    protected static class Config {
        private static final String HOODIE_SRC_BASE_PATH = "hoodie.deltastreamer.source.hoodieincr.path";
        private static final String NUM_INSTANTS_PER_FETCH = "hoodie.deltastreamer.source.hoodieincr.num_instants";
        private static final Integer DEFAULT_NUM_INSTANTS_PER_FETCH = 1;
        private static final String HOODIE_SRC_PARTITION_FIELDS = "hoodie.deltastreamer.source.hoodieincr.partition.fields";
        private static final String HOODIE_SRC_PARTITION_EXTRACTORCLASS = "hoodie.deltastreamer.source.hoodieincr.partition.extractor.class";
        private static final String DEFAULT_HOODIE_SRC_PARTITION_EXTRACTORCLASS = SlashEncodedDayPartitionValueExtractor.class.getCanonicalName();
        private static final String READ_LATEST_INSTANT_ON_MISSING_CKPT = "hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt";
        private static final Boolean DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT = false;

        protected Config() {
        }
    }
}

