/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import kafka.serializer.StringDecoder;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.JsonSource;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka.KafkaUtils;
import org.apache.spark.streaming.kafka.OffsetRange;

public class JsonKafkaSource
extends JsonSource {
    private static Logger log = LogManager.getLogger(JsonKafkaSource.class);
    private final KafkaOffsetGen offsetGen;

    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(properties, sparkContext, sparkSession, schemaProvider);
        this.offsetGen = new KafkaOffsetGen(properties);
    }

    @Override
    protected InputBatch<JavaRDD<String>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        OffsetRange[] offsetRanges = this.offsetGen.getNextOffsetRanges(lastCheckpointStr, sourceLimit);
        long totalNewMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages(offsetRanges);
        if (totalNewMsgs <= 0L) {
            return new InputBatch<JavaRDD<String>>(Option.empty(), lastCheckpointStr.isPresent() ? (String)lastCheckpointStr.get() : "");
        }
        log.info((Object)("About to read " + totalNewMsgs + " from Kafka for topic :" + this.offsetGen.getTopicName()));
        JavaRDD<String> newDataRDD = this.toRDD(offsetRanges);
        return new InputBatch<JavaRDD<String>>(Option.of(newDataRDD), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
    }

    private JavaRDD<String> toRDD(OffsetRange[] offsetRanges) {
        return KafkaUtils.createRDD((JavaSparkContext)this.sparkContext, String.class, String.class, StringDecoder.class, StringDecoder.class, this.offsetGen.getKafkaParams(), (OffsetRange[])offsetRanges).values();
    }
}

