/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.RowBasedSchemaProvider;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.Source;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public abstract class RowSource
extends Source<Dataset<Row>> {
    public RowSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider, Source.SourceType.ROW);
    }

    protected abstract Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> var1, long var2);

    @Override
    protected final InputBatch<Dataset<Row>> fetchNewData(Option<String> lastCkptStr, long sourceLimit) {
        Pair<Option<Dataset<Row>>, String> res = this.fetchNextBatch(lastCkptStr, sourceLimit);
        return (InputBatch)((Option)res.getKey()).map(dsr -> {
            RowBasedSchemaProvider rowSchemaProvider = new RowBasedSchemaProvider(dsr.schema());
            return new InputBatch((Option)res.getKey(), (String)res.getValue(), rowSchemaProvider);
        }).orElseGet(() -> new InputBatch((Option)res.getKey(), (String)res.getValue()));
    }
}

