/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;

public class DFSPathSelector {
    private static final List<String> IGNORE_FILEPREFIX_LIST = Arrays.asList(".", "_");
    private final transient FileSystem fs;
    private final TypedProperties props;

    public DFSPathSelector(TypedProperties props, Configuration hadoopConf) {
        DataSourceUtils.checkRequiredProperties((TypedProperties)props, Arrays.asList("hoodie.deltastreamer.source.dfs.root"));
        this.props = props;
        this.fs = FSUtils.getFs((String)props.getString("hoodie.deltastreamer.source.dfs.root"), (Configuration)hadoopConf);
    }

    public Pair<Option<String>, String> getNextFilePathsAndMaxModificationTime(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            ArrayList<Object> eligibleFiles = new ArrayList<Object>();
            RemoteIterator fitr = this.fs.listFiles(new Path(this.props.getString("hoodie.deltastreamer.source.dfs.root")), true);
            while (fitr.hasNext()) {
                LocatedFileStatus fileStatus = (LocatedFileStatus)fitr.next();
                if (fileStatus.isDirectory() || IGNORE_FILEPREFIX_LIST.stream().anyMatch(pfx -> fileStatus.getPath().getName().startsWith((String)pfx))) continue;
                eligibleFiles.add(fileStatus);
            }
            eligibleFiles.sort(Comparator.comparingLong(FileStatus::getModificationTime));
            long currentBytes = 0L;
            long maxModificationTime = Long.MIN_VALUE;
            ArrayList<FileStatus> filteredFiles = new ArrayList<FileStatus>();
            for (FileStatus fileStatus : eligibleFiles) {
                if (lastCheckpointStr.isPresent() && fileStatus.getModificationTime() <= Long.valueOf((String)lastCheckpointStr.get())) continue;
                if (currentBytes + fileStatus.getLen() >= sourceLimit) break;
                maxModificationTime = fileStatus.getModificationTime();
                currentBytes += fileStatus.getLen();
                filteredFiles.add(fileStatus);
            }
            if (filteredFiles.size() == 0) {
                return new ImmutablePair((Object)Option.empty(), lastCheckpointStr.orElseGet(() -> String.valueOf(Long.MIN_VALUE)));
            }
            String pathStr = filteredFiles.stream().map(f -> f.getPath().toString()).collect(Collectors.joining(","));
            return new ImmutablePair((Object)Option.ofNullable((Object)pathStr), (Object)String.valueOf(maxModificationTime));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to read from source from checkpoint: " + lastCheckpointStr, ioe);
        }
    }

    static class Config {
        private static final String ROOT_INPUT_PATH_PROP = "hoodie.deltastreamer.source.dfs.root";

        Config() {
        }
    }
}

