/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;

public class IncrSourceHelper {
    private static String getStrictlyLowerTimestamp(String timestamp) {
        long ts = Long.parseLong(timestamp);
        Preconditions.checkArgument((ts > 0L ? 1 : 0) != 0, (Object)"Timestamp must be positive");
        Long lower = ts - 1L;
        return "" + lower;
    }

    public static Pair<String, String> calculateBeginAndEndInstants(JavaSparkContext jssc, String srcBasePath, int numInstantsPerFetch, Option<String> beginInstant, boolean readLatestOnMissingBeginInstant) {
        Preconditions.checkArgument((numInstantsPerFetch > 0 ? 1 : 0) != 0, (Object)"Make sure the config hoodie.deltastreamer.source.hoodieincr.num_instants is set to a positive value");
        HoodieTableMetaClient srcMetaClient = new HoodieTableMetaClient(jssc.hadoopConfiguration(), srcBasePath, true);
        HoodieTimeline activeCommitTimeline = srcMetaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants();
        String beginInstantTime = (String)beginInstant.orElseGet(() -> {
            if (readLatestOnMissingBeginInstant) {
                Option lastInstant = activeCommitTimeline.lastInstant();
                return (String)lastInstant.map(hoodieInstant -> IncrSourceHelper.getStrictlyLowerTimestamp(hoodieInstant.getTimestamp())).orElse((Object)"000");
            }
            throw new IllegalArgumentException("Missing begin instant for incremental pull. For reading from latest committed instant set hoodie.deltastreamer.source.hoodie.read_latest_on_midding_ckpt to true");
        });
        Option nthInstant = Option.fromJavaOptional(activeCommitTimeline.findInstantsAfter(beginInstantTime, numInstantsPerFetch).getInstants().reduce((x, y) -> y));
        return Pair.of((Object)beginInstantTime, (Object)nthInstant.map(instant -> instant.getTimestamp()).orElse((Object)beginInstantTime));
    }

    public static void validateInstantTime(Row row, String instantTime, String sinceInstant, String endInstant) {
        Preconditions.checkNotNull((Object)instantTime);
        Preconditions.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)instantTime, (String)sinceInstant, (BiPredicate)HoodieTimeline.GREATER), (Object)("Instant time(_hoodie_commit_time) in row (" + row + ") was : " + instantTime + "but expected to be between " + sinceInstant + "(excl) - " + endInstant + "(incl)"));
        Preconditions.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)instantTime, (String)endInstant, (BiPredicate)HoodieTimeline.LESSER_OR_EQUAL), (Object)("Instant time(_hoodie_commit_time) in row (" + row + ") was : " + instantTime + "but expected to be between " + sinceInstant + "(excl) - " + endInstant + "(incl)"));
    }
}

