/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.UUID;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SqlQueryBasedTransformer
implements Transformer {
    private static volatile Logger log = LogManager.getLogger(SqlQueryBasedTransformer.class);
    private static final String SRC_PATTERN = "<SRC>";
    private static final String TMP_TABLE = "HOODIE_SRC_TMP_TABLE_";

    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        String transformerSQL = properties.getString("hoodie.deltastreamer.transformer.sql");
        if (null == transformerSQL) {
            throw new IllegalArgumentException("Missing configuration : (hoodie.deltastreamer.transformer.sql)");
        }
        String tmpTable = TMP_TABLE.concat(UUID.randomUUID().toString().replace("-", "_"));
        log.info((Object)("Registering tmp table : " + tmpTable));
        rowDataset.registerTempTable(tmpTable);
        String sqlStr = transformerSQL.replaceAll(SRC_PATTERN, tmpTable);
        log.info((Object)("SQL Query for transformation : (" + sqlStr + ")"));
        return sparkSession.sql(sqlStr);
    }

    static class Config {
        private static final String TRANSFORMER_SQL = "hoodie.deltastreamer.transformer.sql";

        Config() {
        }
    }
}

