/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.testutils.providers.SparkProvider;
import org.apache.hudi.utilities.HoodieIndexer;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieIndexer
extends SparkClientFunctionalTestHarness
implements SparkProvider {
    private static final HoodieTestDataGenerator DATA_GENERATOR = new HoodieTestDataGenerator(0L);
    private static int colStatsFileGroupCount = (Integer)HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.defaultValue();
    private HoodieTableMetaClient metaClient;

    @BeforeEach
    public void init() throws IOException {
        this.metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
    }

    @AfterAll
    public static void cleanup() {
        DATA_GENERATOR.close();
    }

    @Test
    public void testGetRequestedPartitionTypes() {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        config.basePath = this.basePath();
        config.tableName = "indexer_test";
        config.indexTypes = "FILES,BLOOM_FILTERS,COLUMN_STATS";
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        List partitionTypes = indexer.getRequestedPartitionTypes(config.indexTypes, Option.empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.BLOOM_FILTERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.COLUMN_STATS));
    }

    @Test
    public void testIsIndexBuiltForAllRequestedTypes() {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        config.basePath = this.basePath();
        config.tableName = "indexer_test";
        config.indexTypes = "BLOOM_FILTERS,COLUMN_STATS";
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        HoodieIndexCommitMetadata commitMetadata = HoodieIndexCommitMetadata.newBuilder().setIndexPartitionInfos(Arrays.asList(new HoodieIndexPartitionInfo(Integer.valueOf(1), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), "0000"))).build();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)indexer.isIndexBuiltForAllRequestedTypes(commitMetadata.getIndexPartitionInfos()));
        config.indexTypes = "COLUMN_STATS";
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)indexer.isIndexBuiltForAllRequestedTypes(commitMetadata.getIndexPartitionInfos()));
    }

    @Test
    public void testIndexerWithNotAllIndexesEnabled() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        this.upsertToTable(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Arrays.asList(MetadataPartitionType.FILES, MetadataPartitionType.BLOOM_FILTERS), Collections.emptyList(), tableName, "streamer-config/indexer.properties");
    }

    @Test
    public void testIndexerWithFilesPartition() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false).withMetadataIndexBloomFilter(true);
        this.upsertToTable(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer.properties");
    }

    @Test
    public void testIndexerForRecordIndex() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false);
        this.upsertToTable(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.RECORD_INDEX, Collections.singletonList(MetadataPartitionType.FILES), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer-record-index.properties");
    }

    @Test
    public void testIndexerWithWriterFinishingFirst() throws IOException {
        String tableName = "indexer_with_writer_finishing_first";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        HoodieMetadataConfig metadataConfig = metadataConfigBuilder.build();
        this.upsertToTable(metadataConfig, tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        this.scheduleAndExecuteIndexing(MetadataPartitionType.COLUMN_STATS, tableName, "streamer-config/indexer.properties");
        HoodieInstant indexingInstant = (HoodieInstant)this.metaClient.getActiveTimeline().filter(i -> "indexing".equals(i.getAction())).getInstants().get(0);
        HoodieIndexPlan indexPlan = TimelineMetadataUtils.deserializeIndexPlan((byte[])((byte[])this.metaClient.getActiveTimeline().readIndexPlanAsBytes(indexingInstant).get()));
        String indexUptoInstantTime = ((HoodieIndexPartitionInfo)indexPlan.getIndexPartitionInfos().get(0)).getIndexUptoInstant();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context(), this.metaClient.getStorage(), metadataConfig, this.metaClient.getBasePathV2().toString());
        HoodieTableMetaClient metadataMetaClient = metadata.getMetadataMetaClient();
        String mdtCommitTime = HoodieTableMetadataUtil.createAsyncIndexerTimestamp((String)indexUptoInstantTime);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(mdtCommitTime));
        this.metaClient.getActiveTimeline().revertToInflight(indexingInstant);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieInstant mdtIndexingCommit = (HoodieInstant)metadataMetaClient.getActiveTimeline().filter(i -> i.getTimestamp().equals(mdtCommitTime)).getInstants().get(0);
        metadataMetaClient.getActiveTimeline().revertToInflight(mdtIndexingCommit);
        metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataMetaClient);
        HoodieHeartbeatClient heartbeatClient = new HoodieHeartbeatClient(metadataMetaClient.getStorage(), metadataMetaClient.getBasePathV2().toString(), Long.valueOf(((Integer)HoodieWriteConfig.CLIENT_HEARTBEAT_INTERVAL_IN_MS.defaultValue()).longValue()), (Integer)HoodieWriteConfig.CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES.defaultValue());
        heartbeatClient.start(mdtCommitTime);
        HoodieMetadataConfig metadataConfigColStats = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true).withMetadataIndexColumnStats(true).build();
        this.upsertToTable(metadataConfigColStats, tableName);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataMetaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(mdtIndexingCommit.getTimestamp()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().getRollbackTimeline().empty());
        heartbeatClient.stop(mdtCommitTime);
        this.upsertToTable(metadataConfigColStats, tableName);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataMetaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataMetaClient.getActiveTimeline().containsInstant(mdtIndexingCommit.getTimestamp()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)metadataMetaClient.getActiveTimeline().getRollbackTimeline().countInstants());
        HoodieInstant rollbackInstant = (HoodieInstant)metadataMetaClient.getActiveTimeline().getRollbackTimeline().firstInstant().get();
        HoodieRollbackMetadata rollbackMetadata = TimelineMetadataUtils.deserializeHoodieRollbackMetadata((byte[])((byte[])metadataMetaClient.getActiveTimeline().readRollbackInfoAsBytes(rollbackInstant).get()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)mdtCommitTime, (Object)((HoodieInstantInfo)rollbackMetadata.getInstantsRollback().stream().findFirst().get()).getCommitTime());
    }

    @Test
    public void testIndexerWithWriterFinishingLast() throws IOException {
        String tableName = "indexer_with_writer_finishing_first";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        HoodieMetadataConfig metadataConfig = metadataConfigBuilder.build();
        this.upsertToTable(metadataConfig, tableName);
        this.upsertToTable(metadataConfig, tableName);
        HoodieInstant commit = (HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get();
        String commitTime = commit.getTimestamp();
        this.metaClient.getActiveTimeline().revertToInflight(commit);
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context(), this.metaClient.getStorage(), metadataConfig, this.metaClient.getBasePathV2().toString());
        HoodieTableMetaClient metadataMetaClient = metadata.getMetadataMetaClient();
        HoodieInstant mdtCommit = (HoodieInstant)metadataMetaClient.getActiveTimeline().filter(i -> i.getTimestamp().equals(commitTime)).getInstants().get(0);
        metadataMetaClient.getActiveTimeline().revertToInflight(mdtCommit);
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = MetadataPartitionType.COLUMN_STATS.name();
        config.runningMode = "scheduleandexecute";
        config.propsFilePath = propsPath;
        config.configs.add(HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.key() + "=" + colStatsFileGroupCount);
        config.configs.add(HoodieMetadataConfig.METADATA_INDEX_CHECK_TIMEOUT_SECONDS + "=1");
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        Throwable cause = ((RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> indexer.start(0))).getCause();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(cause instanceof HoodieMetadataException));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cause.getMessage().contains("Failed to index partition"));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataMetaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getActiveTimeline().containsInstant(commitTime));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(commitTime));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((HoodieInstant)this.metaClient.getActiveTimeline().filter(i -> i.getTimestamp().equals(commitTime)).getInstants().get(0)).isInflight());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((HoodieInstant)metadataMetaClient.getActiveTimeline().filter(i -> i.getTimestamp().equals(commitTime)).getInstants().get(0)).isInflight());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getActiveTimeline().getRollbackTimeline().empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().getRollbackTimeline().empty());
    }

    private static Stream<Arguments> colStatsFileGroupCountParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{2}), Arguments.of((Object[])new Object[]{4}), Arguments.of((Object[])new Object[]{8}));
    }

    @ParameterizedTest
    @MethodSource(value={"colStatsFileGroupCountParams"})
    public void testColStatsFileGroupCount(int colStatsFileGroupCount) {
        TestHoodieIndexer.colStatsFileGroupCount = colStatsFileGroupCount;
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false).withMetadataIndexBloomFilter(true);
        this.upsertToTable(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer.properties");
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Collections.singletonList(MetadataPartitionType.FILES), Arrays.asList(MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer.properties");
        HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(this.metaClient.getMetaPath() + "/metadata").build();
        List partitionFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices((HoodieTableMetaClient)metadataMetaClient, (HoodieTableFileSystemView)HoodieTableMetadataUtil.getFileSystemView((HoodieTableMetaClient)metadataMetaClient), (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        org.junit.jupiter.api.Assertions.assertEquals((int)partitionFileSlices.size(), (int)colStatsFileGroupCount);
    }

    @Test
    public void testIndexerForExceptionWithNonFilesPartition() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false);
        this.upsertToTable(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = MetadataPartitionType.COLUMN_STATS.name();
        config.runningMode = "scheduleandexecute";
        config.propsFilePath = propsPath;
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        Throwable cause = ((RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> indexer.start(0))).getCause();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(cause instanceof HoodieException));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cause.getMessage().contains("Metadata table is not yet initialized"));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer.properties");
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Collections.singletonList(MetadataPartitionType.FILES), Arrays.asList(MetadataPartitionType.BLOOM_FILTERS), tableName, "streamer-config/indexer.properties");
        HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(this.metaClient.getMetaPath() + "/metadata").build();
        List partitionFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices((HoodieTableMetaClient)metadataMetaClient, (HoodieTableFileSystemView)HoodieTableMetadataUtil.getFileSystemView((HoodieTableMetaClient)metadataMetaClient), (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        org.junit.jupiter.api.Assertions.assertEquals((int)partitionFileSlices.size(), (Integer)((Integer)HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.defaultValue()));
    }

    private void upsertToTable(HoodieMetadataConfig metadataConfig, String tableName) {
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfig).build();
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);){
            String instant = HoodieActiveTimeline.createNewInstantTime();
            writeClient.startCommitWithTime(instant);
            List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
            JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
            List statuses = result.collect();
            Assertions.assertNoWriteErrors((List)statuses);
        }
    }

    private void scheduleAndExecuteIndexing(MetadataPartitionType partitionTypeToIndex, String tableName, String propsFilePath) {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource(propsFilePath)).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = partitionTypeToIndex.name();
        config.runningMode = "scheduleandexecute";
        config.propsFilePath = propsPath;
        if (partitionTypeToIndex.getPartitionPath().equals(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
            config.configs.add(HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.key() + "=" + colStatsFileGroupCount);
        }
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
    }

    private void indexMetadataPartitionsAndAssert(MetadataPartitionType partitionTypeToIndex, List<MetadataPartitionType> alreadyCompletedPartitions, List<MetadataPartitionType> nonExistentPartitions, String tableName, String propsFilePath) {
        this.scheduleAndExecuteIndexing(partitionTypeToIndex, tableName, propsFilePath);
        Set completedPartitions = this.metaClient.getTableConfig().getMetadataPartitions();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)completedPartitions.contains(partitionTypeToIndex.getPartitionPath()));
        alreadyCompletedPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)completedPartitions.contains(entry.getPartitionPath())));
        nonExistentPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertFalse((boolean)completedPartitions.contains(entry.getPartitionPath())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)partitionTypeToIndex));
        alreadyCompletedPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)entry)));
    }

    @Test
    public void testIndexerDropPartitionDeletesInstantFromTimeline() {
        String tableName = "indexer_test";
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfigBuilder.build()).build();
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);){
            String instant = HoodieActiveTimeline.createNewInstantTime();
            writeClient.startCommitWithTime(instant);
            List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
            JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
            List statuses = result.collect();
            Assertions.assertNoWriteErrors((List)statuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = MetadataPartitionType.COLUMN_STATS.name();
        config.runningMode = "schedule";
        config.propsFilePath = propsPath;
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option indexInstantInTimeline = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)indexInstantInTimeline.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstant.State.REQUESTED, (Object)((HoodieInstant)indexInstantInTimeline.get()).getState());
        config.runningMode = "dropindex";
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        indexInstantInTimeline = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)indexInstantInTimeline.isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.COLUMN_STATS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
    }

    @Test
    public void testTwoIndexersOneCreateOneDropPartition() {
        String tableName = "indexer_test";
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfigBuilder.build()).build();
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);){
            String instant = HoodieActiveTimeline.createNewInstantTime();
            writeClient.startCommitWithTime(instant);
            List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
            JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
            List statuses = result.collect();
            Assertions.assertNoWriteErrors((List)statuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        HoodieIndexer.Config config = this.getHoodieIndexConfig(MetadataPartitionType.BLOOM_FILTERS.name(), "scheduleandexecute", "streamer-config/indexer-only-bloom.properties", tableName);
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        Option bloomIndexInstant = this.metaClient.reloadActiveTimeline().filterCompletedIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bloomIndexInstant.isPresent());
        config = this.getHoodieIndexConfig(MetadataPartitionType.COLUMN_STATS.name(), "schedule", "streamer-config/indexer.properties", tableName);
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option columnStatsIndexInstant = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)columnStatsIndexInstant.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstant.State.REQUESTED, (Object)((HoodieInstant)columnStatsIndexInstant.get()).getState());
        this.dropIndexAndAssert(MetadataPartitionType.COLUMN_STATS, "streamer-config/indexer.properties", (Option<HoodieInstant>)Option.empty(), tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        this.dropIndexAndAssert(MetadataPartitionType.BLOOM_FILTERS, "streamer-config/indexer-only-bloom.properties", (Option<HoodieInstant>)bloomIndexInstant, tableName);
    }

    private void dropIndexAndAssert(MetadataPartitionType indexType, String resourceFilePath, Option<HoodieInstant> completedIndexInstant, String tableName) {
        HoodieIndexer.Config config = this.getHoodieIndexConfig(indexType.name(), "dropindex", resourceFilePath, tableName);
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option pendingFlights = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pendingFlights.isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)indexType));
        if (completedIndexInstant.isPresent()) {
            org.junit.jupiter.api.Assertions.assertEquals(completedIndexInstant, (Object)this.metaClient.reloadActiveTimeline().filterCompletedIndexTimeline().lastInstant());
        }
    }

    private HoodieIndexer.Config getHoodieIndexConfig(String indexType, String runMode, String resourceFilePath, String tableName) {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource(resourceFilePath)).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = indexType;
        config.runningMode = runMode;
        config.propsFilePath = propsPath;
        return config;
    }

    private static HoodieWriteConfig.Builder getWriteConfigBuilder(String basePath, String tableName) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).forTable(tableName);
    }

    private static HoodieMetadataConfig.Builder getMetadataConfigBuilder(boolean enable, boolean asyncIndex) {
        return HoodieMetadataConfig.newBuilder().enable(enable).withAsyncIndex(asyncIndex);
    }
}

