/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import jodd.io.FileUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.hudi.utilities.HoodieMetadataTableValidator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestHoodieMetadataTableValidator
extends HoodieSparkClientTestBase {
    @Test
    public void testMetadataTableValidation() {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset updates = this.makeUpdateDf("001", 5).cache();
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAdditionalPartitionsinMDT(boolean testFailureCase) throws InterruptedException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).mode(SaveMode.Overwrite).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        String partition1 = "PARTITION1";
        String partition2 = "PARTITION2";
        String partition3 = "PARTITION3";
        List<String> mdtPartitions = Arrays.asList(partition1, partition2, partition3);
        validator.setMetadataPartitionsToReturn(mdtPartitions);
        List<String> fsPartitions = Arrays.asList(partition1, partition2);
        validator.setFsPartitionsToReturn(fsPartitions);
        HoodieTimeline commitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        HoodieTimeline completedTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)metaClient.getCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.filterCompletedInstants()).thenReturn((Object)completedTimeline);
        if (testFailureCase) {
            String partition3CreationTime = HoodieActiveTimeline.createNewInstantTime();
            Thread.sleep(100L);
            String lastIntantCreationTime = HoodieActiveTimeline.createNewInstantTime();
            HoodieInstant lastInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", lastIntantCreationTime);
            Mockito.when((Object)completedTimeline.lastInstant()).thenReturn((Object)Option.of((Object)lastInstant));
            validator.setPartitionCreationTime((Option<String>)Option.of((Object)partition3CreationTime));
            Assertions.assertThrows(HoodieValidationException.class, () -> validator.validatePartitions(engineContext, this.basePath, metaClient));
        } else {
            HoodieInstant lastInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", HoodieActiveTimeline.createNewInstantTime());
            Mockito.when((Object)completedTimeline.lastInstant()).thenReturn((Object)Option.of((Object)lastInstant));
            Thread.sleep(100L);
            validator.setPartitionCreationTime((Option<String>)Option.of((Object)HoodieActiveTimeline.createNewInstantTime()));
            Assertions.assertEquals(mdtPartitions, (Object)validator.validatePartitions(engineContext, this.basePath, metaClient));
        }
    }

    @Test
    public void testRliValidationFalsePositiveCase() throws IOException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset updates = this.makeUpdateDf("001", 5).cache();
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        Dataset inserts2 = this.makeInsertDf("002", 5).cache();
        inserts2.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file://" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.jsc.hadoopConfiguration())).build();
        HoodieInstant lastInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get();
        String latestCompletedCommitMetaFile = this.basePath + "/.hoodie/" + lastInstant.getFileName();
        String tempDir = this.getTempLocation();
        String destFilePath = tempDir + "/" + lastInstant.getFileName();
        FileUtil.move((String)latestCompletedCommitMetaFile, (String)destFilePath);
        MockHoodieMetadataTableValidatorForRli validator = new MockHoodieMetadataTableValidatorForRli(this.jsc, config);
        validator.setOriginalFilePath(latestCompletedCommitMetaFile);
        validator.setDestFilePath(destFilePath);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    private String getTempLocation() {
        try {
            String folderName = "temp_location";
            Path tempPath = this.tempDir.resolve(folderName);
            Files.createDirectories(tempPath, new FileAttribute[0]);
            return tempPath.toAbsolutePath().toString();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected Dataset<Row> makeInsertDf(String instantTime, Integer n) {
        List records = this.dataGen.generateInserts(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
        JavaRDD rdd = this.jsc.parallelize(records);
        return this.sparkSession.read().json(rdd);
    }

    protected Dataset<Row> makeUpdateDf(String instantTime, Integer n) {
        try {
            List records = this.dataGen.generateUpdates(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
            JavaRDD rdd = this.jsc.parallelize(records);
            return this.sparkSession.read().json(rdd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class MockHoodieMetadataTableValidatorForRli
    extends HoodieMetadataTableValidator {
        private String destFilePath;
        private String originalFilePath;

        public MockHoodieMetadataTableValidatorForRli(JavaSparkContext jsc, HoodieMetadataTableValidator.Config cfg) {
            super(jsc, cfg);
        }

        JavaPairRDD<String, Pair<String, String>> getRecordLocationsFromRLI(HoodieSparkEngineContext sparkEngineContext, String basePath, String latestCompletedCommit) {
            try {
                FileUtil.move((String)this.destFilePath, (String)this.originalFilePath);
                return super.getRecordLocationsFromRLI(sparkEngineContext, basePath, latestCompletedCommit);
            }
            catch (IOException e) {
                throw new HoodieException("Move should not have failed");
            }
        }

        public void setDestFilePath(String destFilePath) {
            this.destFilePath = destFilePath;
        }

        public void setOriginalFilePath(String originalFilePath) {
            this.originalFilePath = originalFilePath;
        }
    }

    class MockHoodieMetadataTableValidator
    extends HoodieMetadataTableValidator {
        private List<String> metadataPartitionsToReturn;
        private List<String> fsPartitionsToReturn;
        private Option<String> partitionCreationTime;

        public MockHoodieMetadataTableValidator(JavaSparkContext jsc, HoodieMetadataTableValidator.Config cfg) {
            super(jsc, cfg);
        }

        void setMetadataPartitionsToReturn(List<String> metadataPartitionsToReturn) {
            this.metadataPartitionsToReturn = metadataPartitionsToReturn;
        }

        void setFsPartitionsToReturn(List<String> fsPartitionsToReturn) {
            this.fsPartitionsToReturn = fsPartitionsToReturn;
        }

        void setPartitionCreationTime(Option<String> partitionCreationTime) {
            this.partitionCreationTime = partitionCreationTime;
        }

        List<String> getPartitionsFromFileSystem(HoodieEngineContext engineContext, String basePath, HoodieStorage storage, HoodieTimeline completedTimeline) {
            return this.fsPartitionsToReturn;
        }

        List<String> getPartitionsFromMDT(HoodieEngineContext engineContext, String basePath, HoodieStorage storage) {
            return this.metadataPartitionsToReturn;
        }

        Option<String> getPartitionCreationInstant(HoodieStorage storage, String basePath, String partition) {
            return this.partitionCreationTime;
        }
    }
}

