/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.ParameterException;
import org.apache.hudi.utilities.HoodieSnapshotExporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieSnapshotExporter {
    @ParameterizedTest
    @ValueSource(strings={"json", "parquet", "orc", "hudi"})
    public void testValidateOutputFormatWithValidFormat(String format) {
        Assertions.assertDoesNotThrow(() -> new HoodieSnapshotExporter.OutputFormatValidator().validate(null, format));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "JSON"})
    public void testValidateOutputFormatWithInvalidFormat(String format) {
        Assertions.assertThrows(ParameterException.class, () -> new HoodieSnapshotExporter.OutputFormatValidator().validate(null, format));
    }

    @ParameterizedTest
    @NullSource
    public void testValidateOutputFormatWithNullFormat(String format) {
        Assertions.assertThrows(ParameterException.class, () -> new HoodieSnapshotExporter.OutputFormatValidator().validate(null, format));
    }
}

