/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestManifestFileWriterSpark
extends HoodieSparkClientTestHarness {
    protected HoodieTableType tableType;

    @BeforeEach
    public void setUp() throws IOException {
        this.tableType = HoodieTableType.COPY_ON_WRITE;
        this.initPath();
        this.initSparkContexts("TestHoodieMetadata");
        this.initHoodieStorage();
        this.initMetaClient(this.tableType);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCreateManifestFile(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.getWriteConfig(this.basePath, enableMetadata);
        TestManifestFileWriterSpark.createTestDataForPartitionedTable(this.metaClient, enableMetadata, (HoodieEngineContext)this.context, this.context.getStorageConf(), writeConfig);
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setMetaClient(this.metaClient).build();
        manifestFileWriter.writeManifestFile(false);
        StoragePath manifestFilePath = manifestFileWriter.getManifestFilePath(false);
        try (InputStream is = this.metaClient.getStorage().open(manifestFilePath);){
            List expectedLines = FileIOUtils.readAsUTFStringLines((InputStream)is);
            Assertions.assertEquals((int)9, (int)expectedLines.size(), (String)"there should be 9 base files in total; 3 per partition.");
            expectedLines.forEach(line -> Assertions.assertFalse((boolean)line.contains(this.basePath)));
        }
    }

    private static void createTestDataForPartitionedTable(HoodieTableMetaClient metaClient, boolean enableMetadata, HoodieEngineContext context, StorageConfiguration storageConfiguration, HoodieWriteConfig writeConfig) throws Exception {
        String instantTime = "100";
        HoodieTestTable testTable = null;
        if (enableMetadata) {
            HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)storageConfiguration, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)context);
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)context));
        } else {
            testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        }
        TestManifestFileWriterSpark.doWriteOperation(testTable, "100");
    }

    private HoodieWriteConfig getWriteConfig(String basePath, boolean enableMetadata) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadata).build()).build();
    }

    protected static void doWriteOperation(HoodieTestTable testTable, String commitTime) throws Exception {
        TestManifestFileWriterSpark.doWriteOperation(testTable, commitTime, WriteOperationType.UPSERT);
    }

    protected static void doWriteOperation(HoodieTestTable testTable, String commitTime, WriteOperationType operationType) throws Exception {
        testTable.withPartitionMetaFiles(new String[]{"p1", "p2", "p3"});
        testTable.doWriteOperation(commitTime, operationType, Collections.emptyList(), Arrays.asList("p1", "p2", "p3"), 3);
    }
}

