/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.DummySchemaPostProcessor;
import org.apache.hudi.utilities.DummySchemaProvider;
import org.apache.hudi.utilities.SparkAvroSchemaProvider;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.SchemaProviderPostProcessorConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaPostProcessException;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.schema.SparkAvroPostProcessor;
import org.apache.hudi.utilities.schema.postprocessor.DeleteSupportSchemaPostProcessor;
import org.apache.hudi.utilities.schema.postprocessor.DropColumnSchemaPostProcessor;
import org.apache.hudi.utilities.schema.postprocessor.add.AddPrimitiveColumnSchemaPostProcessor;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.transform.FlatteningTransformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaPostProcessor
extends UtilitiesTestBase {
    private final TypedProperties properties = new TypedProperties();
    private static final String ORIGINAL_SCHEMA = "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}";
    private static final String RESULT_SCHEMA = "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}";

    private static Stream<Arguments> configParams() {
        String[] types = new String[]{"bytes", "string", "int", "long", "float", "double", "boolean"};
        return Stream.of(types).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @BeforeAll
    public static void setupOnce() throws Exception {
        TestSchemaPostProcessor.initTestServices();
    }

    @Test
    public void testPostProcessor() throws IOException {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key(), (Object)DummySchemaPostProcessor.class.getName());
        SchemaProvider provider = UtilHelpers.wrapSchemaProviderWithPostProcessor((SchemaProvider)UtilHelpers.createSchemaProvider((String)DummySchemaProvider.class.getName(), (TypedProperties)this.properties, (JavaSparkContext)jsc), (TypedProperties)this.properties, (JavaSparkContext)jsc, null);
        Schema schema = provider.getSourceSchema();
        Assertions.assertEquals((Object)schema.getType(), (Object)Schema.Type.RECORD);
        Assertions.assertEquals((Object)schema.getName(), (Object)"test");
        Assertions.assertNotNull((Object)schema.getField("testString"));
    }

    @Test
    public void testSparkAvro() throws IOException {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key(), (Object)SparkAvroPostProcessor.class.getName());
        ArrayList<String> transformerClassNames = new ArrayList<String>();
        transformerClassNames.add(FlatteningTransformer.class.getName());
        SchemaProvider provider = UtilHelpers.wrapSchemaProviderWithPostProcessor((SchemaProvider)UtilHelpers.createSchemaProvider((String)SparkAvroSchemaProvider.class.getName(), (TypedProperties)this.properties, (JavaSparkContext)jsc), (TypedProperties)this.properties, (JavaSparkContext)jsc, transformerClassNames);
        Schema schema = provider.getSourceSchema();
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        Assertions.assertEquals((Object)"test", (Object)schema.getFullName());
        Assertions.assertNotNull((Object)schema.getField("day"));
    }

    @Test
    public void testDeleteSupport() {
        DeleteSupportSchemaPostProcessor processor = new DeleteSupportSchemaPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Schema targetSchema = processor.processSchema(schema);
        Assertions.assertNotNull((Object)targetSchema.getField("_hoodie_is_deleted"));
    }

    @Test
    public void testChainedSchemaPostProcessor() {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key(), (Object)"org.apache.hudi.utilities.schema.postprocessor.DeleteSupportSchemaPostProcessor,org.apache.hudi.utilities.DummySchemaPostProcessor");
        SchemaPostProcessor processor = UtilHelpers.createSchemaPostProcessor((String)this.properties.getString(SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key()), (TypedProperties)this.properties, (JavaSparkContext)jsc);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Schema targetSchema = processor.processSchema(schema);
        Assertions.assertNull((Object)targetSchema.getField("_row_key"));
        Assertions.assertNull((Object)targetSchema.getField("_hoodie_is_deleted"));
        Assertions.assertNotNull((Object)targetSchema.getField("testString"));
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key(), (Object)"org.apache.hudi.utilities.DummySchemaPostProcessor,org.apache.hudi.utilities.schema.postprocessor.DeleteSupportSchemaPostProcessor");
        processor = UtilHelpers.createSchemaPostProcessor((String)this.properties.getString(SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR.key()), (TypedProperties)this.properties, (JavaSparkContext)jsc);
        schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        targetSchema = processor.processSchema(schema);
        Assertions.assertNull((Object)targetSchema.getField("_row_key"));
        Assertions.assertNotNull((Object)targetSchema.getField("_hoodie_is_deleted"));
        Assertions.assertNotNull((Object)targetSchema.getField("testString"));
    }

    @Test
    public void testDeleteColumn() {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.DELETE_COLUMN_POST_PROCESSOR_COLUMN.key(), (Object)"rider");
        DropColumnSchemaPostProcessor processor = new DropColumnSchemaPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Schema targetSchema = processor.processSchema(schema);
        Assertions.assertNull((Object)targetSchema.getField("rider"));
        Assertions.assertNotNull((Object)targetSchema.getField("_row_key"));
    }

    @Test
    public void testDeleteColumnThrows() {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.DELETE_COLUMN_POST_PROCESSOR_COLUMN.key(), (Object)"timestamp,_row_key,rider,driver,fare");
        DropColumnSchemaPostProcessor processor = new DropColumnSchemaPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Assertions.assertThrows(HoodieSchemaPostProcessException.class, () -> processor.processSchema(schema));
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testAddPrimitiveTypeColumn(String type) {
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NAME_PROP.key(), (Object)"primitive_column");
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_TYPE_PROP.key(), (Object)type);
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_DOC_PROP.key(), (Object)"primitive column test");
        AddPrimitiveColumnSchemaPostProcessor processor = new AddPrimitiveColumnSchemaPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Schema targetSchema = processor.processSchema(schema);
        Schema.Field newColumn = targetSchema.getField("primitive_column");
        Assertions.assertNotNull((Object)newColumn);
        Assertions.assertEquals((Object)"primitive column test", (Object)newColumn.doc());
        Assertions.assertNotEquals((Object)type, (Object)newColumn.schema().getType().getName());
        this.properties.put((Object)SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NULLABLE_PROP.key(), (Object)false);
        targetSchema = processor.processSchema(schema);
        newColumn = targetSchema.getField("primitive_column");
        Assertions.assertEquals((Object)type, (Object)newColumn.schema().getType().getName());
    }

    @Test
    public void testSparkAvroSchema() throws IOException {
        SparkAvroPostProcessor processor = new SparkAvroPostProcessor(this.properties, null);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}");
        Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"}]}", (Object)processor.processSchema(schema).toString());
    }
}

