/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.callback;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieCommitCallbackFactory;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.callback.kafka.HoodieWriteCommitKafkaCallback;
import org.apache.hudi.utilities.callback.kafka.HoodieWriteCommitKafkaCallbackConfig;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.spark.streaming.kafka010.KafkaTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestKafkaCallbackProvider
extends UtilitiesTestBase {
    private final String testTopicName = "hoodie_test_" + UUID.randomUUID();
    private KafkaTestUtils testUtils;

    @BeforeAll
    public static void initClass() throws Exception {
        UtilitiesTestBase.initTestServices();
    }

    @Override
    @BeforeEach
    public void setup() {
        this.testUtils = new KafkaTestUtils();
        this.testUtils.setup();
    }

    @AfterEach
    public void tearDown() {
        this.testUtils.teardown();
    }

    @AfterAll
    public static void cleanupClass() throws IOException {
        UtilitiesTestBase.cleanUpUtilitiesTestServices();
    }

    @Test
    public void testCallbackMessage() {
        this.testUtils.createTopic(this.testTopicName, 2);
        HoodieWriteConfig hoodieConfig = this.createConfigForKafkaCallback();
        HoodieWriteCommitCallback commitCallback = HoodieCommitCallbackFactory.create((HoodieWriteConfig)hoodieConfig);
        List stats = HoodieTestUtils.generateFakeHoodieWriteStat((int)1);
        Assertions.assertDoesNotThrow(() -> commitCallback.call(new HoodieWriteCommitCallbackMessage(HoodieTestTable.makeNewCommitTime(), hoodieConfig.getTableName(), hoodieConfig.getBasePath(), stats)));
    }

    private HoodieWriteConfig createConfigForKafkaCallback() {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieWriteCommitKafkaCallbackConfig.TOPIC.key(), this.testTopicName);
        props.setProperty(HoodieWriteCommitKafkaCallbackConfig.BOOTSTRAP_SERVERS.key(), this.testUtils.brokerAddress());
        HoodieWriteConfig hoodieWriteConfig = HoodieWriteConfig.newBuilder().withCallbackConfig(HoodieWriteCommitCallbackConfig.newBuilder().writeCommitCallbackOn("true").withCallbackClass(HoodieWriteCommitKafkaCallback.class.getName()).fromProperties((Properties)props).build()).withPath("/tmp").forTable("test-trip-table").build(false);
        return hoodieWriteConfig;
    }
}

