/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.TestHoodieSparkUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.TestHoodieDeltaStreamerSchemaEvolutionBase;
import org.apache.hudi.utilities.streamer.ErrorEvent;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Disabled
public class TestHoodieDeltaStreamerSchemaEvolutionExtensive
extends TestHoodieDeltaStreamerSchemaEvolutionBase {
    protected String typePromoUpdates;

    protected void testBase(String updateFile, String updateColumn, String condition, int count) throws Exception {
        this.testBase(updateFile, updateColumn, condition, count, null);
    }

    protected void testBase(String updateFile, String updateColumn, String condition, int count, ErrorEvent.ErrorReason reason) throws Exception {
        HashMap<String, Integer> conditions = new HashMap<String, Integer>();
        conditions.put(condition, count);
        this.testBase(updateFile, updateColumn, conditions, true, reason);
    }

    protected void testBase(String updateFile, String updateColumn, Map<String, Integer> conditions) throws Exception {
        this.testBase(updateFile, updateColumn, conditions, null);
    }

    protected void testBase(String updateFile, String updateColumn, Map<String, Integer> conditions, ErrorEvent.ErrorReason reason) throws Exception {
        this.testBase(updateFile, updateColumn, conditions, true, reason);
    }

    protected void doFirstDeltaWrite() throws Exception {
        this.doDeltaWriteBase("start.json", true, false, null);
    }

    protected void doFirstDeltaWriteTypePromo(String colName, DataType colType) throws Exception {
        this.doDeltaWriteBase("startTypePromotion.json", true, false, true, colName, colType);
    }

    protected void doDeltaWriteTypePromo(String resourceString, String colName, DataType colType) throws Exception {
        this.doDeltaWriteBase(resourceString, false, false, true, colName, colType);
    }

    protected void doNonNullableDeltaWrite(String resourceString, String colName) throws Exception {
        this.doDeltaWriteBase(resourceString, false, true, colName);
    }

    protected void doDeltaWrite(String resourceString) throws Exception {
        this.doDeltaWriteBase(resourceString, false, false, null);
    }

    protected void doDeltaWriteBase(String resourceString, Boolean isFirst, Boolean nonNullable, String colName) throws Exception {
        this.doDeltaWriteBase(resourceString, isFirst, nonNullable, false, colName, null);
    }

    protected void doDeltaWriteBase(String resourceString, Boolean isFirst, Boolean nonNullable, Boolean castColumn, String colName, DataType colType) throws Exception {
        String datapath = String.class.getResource("/data/schema-evolution/" + resourceString).getPath();
        Dataset df = sparkSession.read().json(datapath);
        if (nonNullable.booleanValue()) {
            df = TestHoodieSparkUtils.setColumnNotNullable((Dataset)df, (String)colName);
        }
        if (castColumn.booleanValue()) {
            Column col = df.col(colName);
            df = df.withColumn(colName, col.cast(colType));
        }
        this.addData((Dataset<Row>)df, isFirst);
        this.deltaStreamer.sync();
    }

    protected void testBase(String updateFile, String updateColumn, Map<String, Integer> conditions, Boolean nullable, ErrorEvent.ErrorReason reason) throws Exception {
        boolean isCow = this.tableType.equals("COPY_ON_WRITE");
        PARQUET_SOURCE_ROOT = basePath + "parquetFilesDfs" + testNum++;
        this.tableName = "test_parquet_table" + testNum;
        this.tableBasePath = basePath + this.tableName;
        this.deltaStreamer = new HoodieDeltaStreamer(this.getDeltaStreamerConfig(), jsc);
        this.doFirstDeltaWrite();
        int numRecords = 6;
        int numFiles = 3;
        this.assertRecordCount(numRecords);
        this.assertFileNumber(numFiles, isCow);
        if (this.multiLogFiles.booleanValue()) {
            this.doDeltaWrite("extraLogFiles.json");
            this.assertRecordCount(numRecords);
            this.assertFileNumber(numFiles, false);
        }
        if (this.addFilegroups.booleanValue()) {
            this.doDeltaWrite("newFileGroups.json");
            this.assertRecordCount(numRecords += 3);
            this.assertFileNumber(numFiles += 3, isCow);
        }
        if (!nullable.booleanValue()) {
            this.doNonNullableDeltaWrite(updateFile, updateColumn);
        } else {
            this.doDeltaWrite(updateFile);
        }
        if (this.shouldCluster.booleanValue()) {
            this.assertBaseFileOnlyNumber(3);
        } else if (this.shouldCompact.booleanValue() || isCow) {
            this.assertBaseFileOnlyNumber(numFiles);
        } else {
            numFiles += 2;
            if (updateFile.equals("testAddColChangeOrderAllFiles.json")) {
                ++numFiles;
            } else if (this.withErrorTable) {
                --numFiles;
            }
            this.assertFileNumber(numFiles, false);
        }
        this.assertRecordCount(numRecords);
        Dataset df = sparkSession.read().format("hudi").load(this.tableBasePath);
        df.show(9, false);
        df.select(updateColumn, new String[0]).show(9);
        for (String condition : conditions.keySet()) {
            Assertions.assertEquals((long)conditions.get(condition).intValue(), (long)df.filter(condition).count());
        }
        if (this.withErrorTable) {
            ArrayList recs = new ArrayList();
            for (String key : TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTable.commited.keySet()) {
                Option<JavaRDD> errors = TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTable.commited.get(key);
                if (!errors.isPresent() || ((JavaRDD)errors.get()).isEmpty()) continue;
                recs.addAll(((JavaRDD)errors.get()).collect());
            }
            Assertions.assertEquals((int)1, (int)recs.size());
            Assertions.assertEquals((Object)((ErrorEvent)recs.get(0)).getReason(), (Object)reason);
        }
    }

    protected static Stream<Arguments> testArgs() {
        Stream.Builder<Arguments> b = Stream.builder();
        for (Boolean rowWriterEnable : new Boolean[]{true}) {
            for (Boolean addFilegroups : new Boolean[]{false, true}) {
                for (Boolean multiLogFiles : new Boolean[]{false, true}) {
                    for (Boolean shouldCluster : new Boolean[]{false, true}) {
                        for (String tableType : new String[]{"COPY_ON_WRITE", "MERGE_ON_READ"}) {
                            if (multiLogFiles.booleanValue() && !tableType.equals("MERGE_ON_READ")) continue;
                            b.add(Arguments.of((Object[])new Object[]{tableType, shouldCluster, false, rowWriterEnable, addFilegroups, multiLogFiles}));
                        }
                    }
                    b.add(Arguments.of((Object[])new Object[]{"MERGE_ON_READ", false, true, rowWriterEnable, addFilegroups, multiLogFiles}));
                }
            }
        }
        return b.build();
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testErrorTable(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.withErrorTable = true;
        this.useSchemaProvider = false;
        this.useTransformer = false;
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testMissingRecordKey.json", "driver", "driver = 'driver-003'", 1, ErrorEvent.ErrorReason.RECORD_CREATION);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testErrorTableWithSchemaProvider(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.withErrorTable = true;
        this.useSchemaProvider = true;
        this.useTransformer = false;
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testMissingRecordKey.json", "driver", "driver = 'driver-003'", 1, ErrorEvent.ErrorReason.INVALID_RECORD_SCHEMA);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testErrorTableWithTransformer(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.withErrorTable = true;
        this.useSchemaProvider = true;
        this.useTransformer = true;
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testMissingRecordKey.json", "driver", "driver = 'driver-003'", 1, ErrorEvent.ErrorReason.AVRO_DESERIALIZATION_FAILURE);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddColRoot(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testAddColRoot.json", "zextra_col", "zextra_col = 'yes'", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testDropColRoot(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testDropColRoot.json", "trip_type", "trip_type is NULL", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddMetaCol(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testAddMetaCol.json", "_extra_col", "_extra_col = 'yes'", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddColStruct(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testAddColStruct.json", "tip_history.zextra_col", "tip_history[0].zextra_col = 'yes'", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testDropColStruct(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testDropColStruct.json", "tip_history.currency", "tip_history[0].currency is NULL", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddComplexField(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testAddComplexField.json", "zcomplex_array", "size(zcomplex_array) > 0", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddColChangeOrder(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.testBase("testAddColChangeOrderAllFiles.json", "extra_col", "extra_col = 'yes'", 2);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testAddAndDropCols(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        HashMap<String, Integer> conditions = new HashMap<String, Integer>();
        conditions.put("distance_in_meters is NULL", 2);
        conditions.put("tip_history[0].currency is NULL", 2);
        conditions.put("tip_history[0].zextra_col_nest = 'yes'", 2);
        conditions.put("zextra_col = 'yes'", 2);
        this.testBase("testAddAndDropCols.json", "tip_history", conditions);
    }

    protected void assertDataType(String colName, DataType expectedType) {
        Assertions.assertEquals((Object)expectedType, (Object)sparkSession.read().format("hudi").load(this.tableBasePath).select(colName, new String[0]).schema().fields()[0].dataType());
    }

    protected void testTypePromotionBase(String colName, DataType startType, DataType updateType) throws Exception {
        this.testTypePromotionBase(colName, startType, updateType, updateType);
    }

    protected void testTypeDemotionBase(String colName, DataType startType, DataType updateType) throws Exception {
        this.testTypePromotionBase(colName, startType, updateType, startType);
    }

    protected void testTypePromotionBase(String colName, DataType startType, DataType updateType, DataType endType) throws Exception {
        boolean isCow = this.tableType.equals("COPY_ON_WRITE");
        PARQUET_SOURCE_ROOT = basePath + "parquetFilesDfs" + testNum++;
        this.tableName = "test_parquet_table" + testNum;
        this.tableBasePath = basePath + this.tableName;
        this.deltaStreamer = new HoodieDeltaStreamer(this.getDeltaStreamerConfig(), jsc);
        this.doFirstDeltaWriteTypePromo(colName, startType);
        int numRecords = 6;
        int numFiles = 3;
        this.assertRecordCount(numRecords);
        this.assertFileNumber(numFiles, isCow);
        this.assertDataType(colName, startType);
        if (this.multiLogFiles.booleanValue()) {
            this.doDeltaWriteTypePromo("extraLogFilesTypePromo.json", colName, startType);
            this.assertRecordCount(numRecords);
            this.assertFileNumber(numFiles, false);
        }
        if (this.addFilegroups.booleanValue()) {
            this.doDeltaWriteTypePromo("newFileGroupsTypePromo.json", colName, startType);
            this.assertRecordCount(numRecords += 3);
            this.assertFileNumber(numFiles += 3, isCow);
        }
        this.doDeltaWriteTypePromo(this.typePromoUpdates, colName, updateType);
        if (this.shouldCluster.booleanValue()) {
            this.assertBaseFileOnlyNumber(3);
        } else if (this.shouldCompact.booleanValue() || isCow) {
            this.assertBaseFileOnlyNumber(numFiles);
        } else {
            this.assertFileNumber(numFiles += 2, false);
        }
        this.assertRecordCount(numRecords);
        sparkSession.read().format("hudi").load(this.tableBasePath).select(colName, new String[0]).show(9);
        this.assertDataType(colName, endType);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testTypePromotion(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.testTypePromotion(tableType, shouldCluster, shouldCompact, rowWriterEnable, addFilegroups, multiLogFiles, false);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testTypePromotionDropCols(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles) throws Exception {
        this.testTypePromotion(tableType, shouldCluster, shouldCompact, rowWriterEnable, addFilegroups, multiLogFiles, true);
    }

    public void testTypePromotion(String tableType, Boolean shouldCluster, Boolean shouldCompact, Boolean rowWriterEnable, Boolean addFilegroups, Boolean multiLogFiles, Boolean dropCols) throws Exception {
        this.tableType = tableType;
        this.shouldCluster = shouldCluster;
        this.shouldCompact = shouldCompact;
        this.rowWriterEnable = rowWriterEnable;
        this.addFilegroups = addFilegroups;
        this.multiLogFiles = multiLogFiles;
        this.typePromoUpdates = dropCols != false ? "endTypePromotionDropCols.json" : "endTypePromotion.json";
        this.testTypePromotionBase("distance_in_meters", DataTypes.IntegerType, DataTypes.LongType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.IntegerType, DataTypes.FloatType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.IntegerType, DataTypes.DoubleType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.IntegerType, DataTypes.StringType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.LongType, DataTypes.FloatType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.LongType, DataTypes.DoubleType);
        this.testTypePromotionBase("distance_in_meters", DataTypes.LongType, DataTypes.StringType);
        this.testTypePromotionBase("begin_lat", DataTypes.FloatType, DataTypes.DoubleType);
        this.testTypePromotionBase("begin_lat", DataTypes.FloatType, DataTypes.StringType);
        this.testTypePromotionBase("begin_lat", DataTypes.DoubleType, DataTypes.StringType);
        this.testTypeDemotionBase("rider", DataTypes.StringType, DataTypes.BinaryType);
        this.testTypeDemotionBase("rider", DataTypes.BinaryType, DataTypes.StringType);
        this.testTypePromotionBase("fare", (DataType)this.createFareStruct(DataTypes.FloatType), (DataType)this.createFareStruct(DataTypes.DoubleType, dropCols), (DataType)this.createFareStruct(DataTypes.DoubleType));
        this.testTypePromotionBase("fare", (DataType)this.createFareStruct(DataTypes.FloatType), (DataType)this.createFareStruct(DataTypes.StringType, dropCols), (DataType)this.createFareStruct(DataTypes.StringType));
        this.testTypePromotionBase("tip_history", (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType), (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType));
        this.testTypePromotionBase("tip_history", (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType), (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType));
        this.testTypePromotionBase("tip_history", (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType), (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType));
        this.testTypeDemotionBase("distance_in_meters", DataTypes.LongType, DataTypes.IntegerType);
        this.testTypeDemotionBase("distance_in_meters", DataTypes.StringType, DataTypes.LongType);
        this.testTypePromotionBase("fare", (DataType)this.createFareStruct(DataTypes.DoubleType), (DataType)this.createFareStruct(DataTypes.FloatType, dropCols), (DataType)this.createFareStruct(DataTypes.DoubleType));
        this.testTypePromotionBase("fare", (DataType)this.createFareStruct(DataTypes.StringType), (DataType)this.createFareStruct(DataTypes.DoubleType, dropCols), (DataType)this.createFareStruct(DataTypes.StringType));
        this.testTypeDemotionBase("tip_history", (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType), (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType));
        this.testTypeDemotionBase("tip_history", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType));
    }
}

