/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.streamer.SparkSampleWritesUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSparkSampleWritesUtils
extends SparkClientFunctionalTestHarness {
    private HoodieTestDataGenerator dataGen;
    private HoodieTableMetaClient metaClient;

    @BeforeEach
    public void setUp() throws IOException {
        this.dataGen = new HoodieTestDataGenerator(57069L);
        this.metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
    }

    @AfterEach
    public void tearDown() {
        this.dataGen.close();
    }

    public String basePath() {
        return this.tempDir.toAbsolutePath().toString();
    }

    @Test
    public void skipOverwriteRecordSizeEstimateWhenTimelineNonEmpty() throws Exception {
        String commitTime = HoodieTestTable.makeNewCommitTime();
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(commitTime);
        int originalRecordSize = 100;
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieStreamerConfig.SAMPLE_WRITES_ENABLED.key(), (Object)"true");
        props.put((Object)HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key(), (Object)String.valueOf(originalRecordSize));
        HoodieWriteConfig originalWriteConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)props).withPath(this.basePath()).build();
        JavaRDD records = this.jsc().parallelize(this.dataGen.generateInserts(commitTime, Integer.valueOf(1)), 1);
        Option writeConfigOpt = SparkSampleWritesUtils.getWriteConfigWithRecordSizeEstimate((JavaSparkContext)this.jsc(), (Option)Option.of((Object)records), (HoodieWriteConfig)originalWriteConfig);
        Assertions.assertFalse((boolean)writeConfigOpt.isPresent());
        Assertions.assertEquals((int)originalRecordSize, (int)originalWriteConfig.getCopyOnWriteRecordSizeEstimate(), (String)"Original record size estimate should not be changed.");
    }

    @Test
    public void overwriteRecordSizeEstimateForEmptyTable() {
        int originalRecordSize = 100;
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieStreamerConfig.SAMPLE_WRITES_ENABLED.key(), (Object)"true");
        props.put((Object)HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key(), (Object)String.valueOf(originalRecordSize));
        HoodieWriteConfig originalWriteConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)props).forTable("foo").withPath(this.basePath()).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").build();
        String commitTime = HoodieTestDataGenerator.getCommitTimeAtUTC((long)1L);
        JavaRDD records = this.jsc().parallelize(this.dataGen.generateInserts(commitTime, Integer.valueOf(2000)), 2);
        Option writeConfigOpt = SparkSampleWritesUtils.getWriteConfigWithRecordSizeEstimate((JavaSparkContext)this.jsc(), (Option)Option.of((Object)records), (HoodieWriteConfig)originalWriteConfig);
        Assertions.assertTrue((boolean)writeConfigOpt.isPresent());
        Assertions.assertEquals((double)779.0, (double)((HoodieWriteConfig)writeConfigOpt.get()).getCopyOnWriteRecordSizeEstimate(), (double)10.0);
    }
}

