/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.exception.HoodieTransformPlanException;
import org.apache.hudi.utilities.transform.ChainedTransformer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestChainedTransformer
extends SparkClientFunctionalTestHarness {
    @Test
    public void testChainedTransformation() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"foo", (DataType)DataTypes.StringType, (boolean)false)});
        Row r1 = RowFactory.create((Object[])new Object[]{"100"});
        Row r2 = RowFactory.create((Object[])new Object[]{"200"});
        Dataset original = this.spark().sqlContext().createDataFrame(Arrays.asList(r1, r2), schema);
        Transformer t1 = (jsc, sparkSession, dataset, properties) -> dataset.withColumnRenamed("foo", "bar");
        Transformer t2 = (jsc, sparkSession, dataset, properties) -> dataset.withColumn("bar", dataset.col("bar").cast(DataTypes.IntegerType));
        ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(t1, t2));
        Dataset transformed = transformer.apply(this.jsc(), this.spark(), original, null);
        Assertions.assertEquals((long)2L, (long)transformed.count());
        Assertions.assertArrayEquals((Object[])new String[]{"bar"}, (Object[])transformed.columns());
        List rows = transformed.collectAsList();
        Assertions.assertEquals((int)100, (int)((Row)rows.get(0)).getInt(0));
        Assertions.assertEquals((int)200, (int)((Row)rows.get(1)).getInt(0));
    }

    @ParameterizedTest
    @ValueSource(strings={":org.apache.hudi.utilities.transform.FlatteningTransformer,T2:org.apache.hudi.utilities.transform.FlatteningTransformer", "T1:org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer", "T1::org.apache.hudi.utilities.transform.FlatteningTransformer", "org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer"})
    public void testChainedTransformerValidationFails(String transformerName) {
        try {
            ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(transformerName.split(",")), Option::empty);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof HoodieTransformPlanException), (String)e.getMessage());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"T1:org.apache.hudi.utilities.transform.FlatteningTransformer,T2:org.apache.hudi.utilities.transform.FlatteningTransformer", "T2:org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer", "abc:org.apache.hudi.utilities.transform.FlatteningTransformer,def:org.apache.hudi.utilities.transform.FlatteningTransformer", "org.apache.hudi.utilities.transform.FlatteningTransformer,org.apache.hudi.utilities.transform.FlatteningTransformer"})
    public void testChainedTransformerValidationPasses(String transformerName) {
        ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(transformerName.split(",")), Option::empty);
        Assertions.assertNotNull((Object)transformer);
    }

    @Test
    public void testChainedTransformerTransformedSchema() {
        String transformerName = "org.apache.hudi.utilities.transform.FlatteningTransformer";
        ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(transformerName.split(",")), () -> Option.of((Object)HoodieTestDataGenerator.NESTED_AVRO_SCHEMA));
        StructType transformedSchema = transformer.transformedSchema(this.jsc(), this.spark(), null, new TypedProperties());
        Assertions.assertTrue((boolean)Arrays.asList(transformedSchema.fieldNames()).contains("fare_amount"));
        Assertions.assertTrue((boolean)Arrays.asList(transformedSchema.fieldNames()).contains("fare_currency"));
        Assertions.assertNotNull((Object)transformer);
    }

    @Test
    public void assertSchemaSupplierIsCalledPerInvocationOfTransformedSchema() {
        String transformerName = "org.apache.hudi.utilities.transform.FlatteningTransformer";
        AtomicInteger count = new AtomicInteger(0);
        Supplier<Option> schemaSupplier = () -> {
            if (count.getAndIncrement() == 0) {
                return Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
            }
            return Option.of((Object)HoodieTestDataGenerator.NESTED_AVRO_SCHEMA);
        };
        ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(transformerName.split(",")), schemaSupplier);
        StructType transformedSchema1 = transformer.transformedSchema(this.jsc(), this.spark(), null, new TypedProperties());
        StructType transformedSchema2 = transformer.transformedSchema(this.jsc(), this.spark(), null, new TypedProperties());
        Assertions.assertNotEquals((Object)transformedSchema1, (Object)transformedSchema2);
        Assertions.assertEquals((int)2, (int)count.get());
    }
}

