/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.io.IOException;
import org.apache.avro.SchemaParseException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.hudi.utilities.testutils.SanitizationTestUtils;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFilebasedSchemaProvider
extends UtilitiesTestBase {
    private FilebasedSchemaProvider schemaProvider;

    @BeforeAll
    public static void initClass() throws Exception {
        UtilitiesTestBase.initTestServices(false, false, false);
    }

    @AfterAll
    public static void cleanUpUtilitiesTestServices() {
        UtilitiesTestBase.cleanUpUtilitiesTestServices();
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        super.teardown();
    }

    @Test
    public void properlyFormattedNestedSchemaTest() throws IOException {
        this.schemaProvider = new FilebasedSchemaProvider(UtilitiesTestBase.Helpers.setupSchemaOnDFS("streamer-config", "file_schema_provider_valid.avsc"), jsc);
        Assertions.assertEquals((Object)this.schemaProvider.getSourceSchema(), (Object)SanitizationTestUtils.generateProperFormattedSchema());
    }

    @Test
    public void renameBadlyFormattedSchemaTest() throws IOException {
        TypedProperties props = UtilitiesTestBase.Helpers.setupSchemaOnDFS("streamer-config", "file_schema_provider_invalid.avsc");
        props.put((Object)HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES.key(), (Object)"true");
        this.schemaProvider = new FilebasedSchemaProvider(props, jsc);
        Assertions.assertEquals((Object)this.schemaProvider.getSourceSchema(), (Object)SanitizationTestUtils.generateRenamedSchemaWithDefaultReplacement());
    }

    @Test
    public void renameBadlyFormattedSchemaWithPropertyDisabledTest() {
        Assertions.assertThrows(SchemaParseException.class, () -> new FilebasedSchemaProvider(UtilitiesTestBase.Helpers.setupSchemaOnDFS("streamer-config", "file_schema_provider_invalid.avsc"), jsc));
    }

    @Test
    public void renameBadlyFormattedSchemaWithAltCharMaskConfiguredTest() throws IOException {
        TypedProperties props = UtilitiesTestBase.Helpers.setupSchemaOnDFS("streamer-config", "file_schema_provider_invalid.avsc");
        props.put((Object)HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES.key(), (Object)"true");
        props.put((Object)HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK.key(), (Object)"_");
        this.schemaProvider = new FilebasedSchemaProvider(props, jsc);
        Assertions.assertEquals((Object)this.schemaProvider.getSourceSchema(), (Object)SanitizationTestUtils.generateRenamedSchemaWithConfiguredReplacement());
    }
}

