/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.utilities.schema.LazyCastingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLazyCastingIterator {
    private static final String NESTED_COL_SCHEMA = "{\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}";
    private static final String EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"int_col\", \"type\": [\"null\", \"int\"], \"default\": null },{\"name\": \"long_col\", \"type\": [\"null\", \"long\"], \"default\": null },{\"name\": \"nested_col\",\"type\": [\"null\", {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}]}]}";
    private static final String EXAMPLE_SCHEMA_WITHOUT_NESTED_COL = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"int_col\", \"type\": [\"null\", \"int\"], \"default\": null },{\"name\": \"long_col\", \"type\": [\"null\", \"long\"], \"default\": null }]}";
    private static final String EXAMPLE_SCHEMA_INT_COL_AS_LONG = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"int_col\", \"type\": [\"null\", \"long\"], \"default\": null },{\"name\": \"long_col\", \"type\": [\"null\", \"long\"], \"default\": null },{\"name\": \"nested_col\",\"type\": [\"null\", {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}]}]}";
    private static final String EXAMPLE_SCHEMA_LONG_COL_AS_INT = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"int_col\", \"type\": [\"null\", \"int\"], \"default\": null },{\"name\": \"long_col\", \"type\": [\"null\", \"int\"], \"default\": null },{\"name\": \"nested_col\",\"type\": [\"null\", {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}]}]}";
    private static final GenericRecord GEN_RECORD_EXAMPLE_WITH_NESTED = TestLazyCastingIterator.getRecordWithExampleSchema();
    private static final GenericRecord GEN_RECORD_EXAMPLE_WITH_NULL_NESTED = TestLazyCastingIterator.getRecordWithExampleSchemaNullNestedCol();
    private static final GenericRecord GEN_RECORD_EXAMPLE_WITHOUT_NESTED = TestLazyCastingIterator.getRecordWithExampleSchemaWithoutNestedCol();
    private static final GenericRecord GEN_RECORD_EXAMPLE_INT_COL_AS_LONG = TestLazyCastingIterator.getRecordWithExampleSchemaIntColAsLong();
    private static final GenericRecord GEN_RECORD_EXAMPLE_LONG_COL_AS_INT = TestLazyCastingIterator.getRecordWithExampleSchemaLongColAsInt();

    @Test
    public void testHappyPath() {
        List<GenericRecord> genericRecords = Collections.singletonList(GEN_RECORD_EXAMPLE_WITH_NESTED);
        LazyCastingIterator itr = new LazyCastingIterator(genericRecords.iterator(), EXAMPLE_SCHEMA);
        GenericRecord outGenRec = (GenericRecord)itr.next();
        Assertions.assertEquals((Object)genericRecords.get(0), (Object)outGenRec);
    }

    @Test
    public void testDataWithAdditionalCol() {
        List<GenericRecord> genericRecords = Collections.singletonList(GEN_RECORD_EXAMPLE_WITH_NESTED);
        LazyCastingIterator itr = new LazyCastingIterator(genericRecords.iterator(), EXAMPLE_SCHEMA_WITHOUT_NESTED_COL);
        GenericRecord outGenRec = (GenericRecord)itr.next();
        Assertions.assertEquals((Object)GEN_RECORD_EXAMPLE_WITHOUT_NESTED, (Object)outGenRec);
    }

    @Test
    public void testDataWithMissingCol() {
        List<GenericRecord> genericRecords = Collections.singletonList(GEN_RECORD_EXAMPLE_WITHOUT_NESTED);
        LazyCastingIterator itr = new LazyCastingIterator(genericRecords.iterator(), EXAMPLE_SCHEMA);
        GenericRecord outGenRec = (GenericRecord)itr.next();
        Assertions.assertEquals((Object)GEN_RECORD_EXAMPLE_WITH_NULL_NESTED, (Object)outGenRec);
    }

    @Test
    public void testDataForIntToLongPromotion() {
        List<GenericRecord> genericRecords = Collections.singletonList(GEN_RECORD_EXAMPLE_LONG_COL_AS_INT);
        LazyCastingIterator itr = new LazyCastingIterator(genericRecords.iterator(), EXAMPLE_SCHEMA);
        GenericRecord outGenRec = (GenericRecord)itr.next();
        Assertions.assertEquals((Object)GEN_RECORD_EXAMPLE_WITH_NESTED, (Object)outGenRec);
    }

    @Test
    public void testDataForLongToIntPromotion() {
        List<GenericRecord> genericRecords = Collections.singletonList(GEN_RECORD_EXAMPLE_INT_COL_AS_LONG);
        LazyCastingIterator itr = new LazyCastingIterator(genericRecords.iterator(), EXAMPLE_SCHEMA);
        Exception e = (Exception)Assertions.assertThrows(RuntimeException.class, () -> itr.next(), (String)"Should error out since long cannot be promoted to int");
        Assertions.assertTrue((boolean)e.getMessage().contains("cannot support rewrite value for schema type: \"int\" since the old schema type is: \"long\""));
    }

    public static GenericRecord getRecordWithExampleSchema() {
        return TestLazyCastingIterator.getRecordWithExampleSchema(TestLazyCastingIterator.getNestedColRecord("val1", 10L));
    }

    public static GenericRecord getRecordWithExampleSchemaIntColAsLong() {
        return TestLazyCastingIterator.getRecordWithExampleSchemaIntColAsLong(TestLazyCastingIterator.getNestedColRecord("val1", 10L));
    }

    public static GenericRecord getRecordWithExampleSchemaLongColAsInt() {
        return TestLazyCastingIterator.getRecordWithExampleSchemaLongColAsInt(TestLazyCastingIterator.getNestedColRecord("val1", 10L));
    }

    public static GenericRecord getRecordWithExampleSchemaNullNestedCol() {
        return TestLazyCastingIterator.getRecordWithExampleSchema(null);
    }

    public static GenericRecord getNestedColRecord(String prop1Value, Long prop2Value) {
        GenericData.Record nestedColRecord = new GenericData.Record(new Schema.Parser().parse(NESTED_COL_SCHEMA));
        nestedColRecord.put("prop1", (Object)prop1Value);
        nestedColRecord.put("prop2", (Object)prop2Value);
        return nestedColRecord;
    }

    public static GenericRecord getRecordWithExampleSchema(GenericRecord nestedColRecord) {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("int_col", (Object)10);
        record.put("long_col", (Object)100L);
        if (nestedColRecord != null) {
            record.put("nested_col", (Object)nestedColRecord);
        }
        return record;
    }

    public static GenericRecord getRecordWithExampleSchemaIntColAsLong(GenericRecord nestedColRecord) {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA_INT_COL_AS_LONG));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("int_col", (Object)10L);
        record.put("long_col", (Object)100L);
        if (nestedColRecord != null) {
            record.put("nested_col", (Object)nestedColRecord);
        }
        return record;
    }

    public static GenericRecord getRecordWithExampleSchemaLongColAsInt(GenericRecord nestedColRecord) {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA_LONG_COL_AS_INT));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("int_col", (Object)10);
        record.put("long_col", (Object)100);
        if (nestedColRecord != null) {
            record.put("nested_col", (Object)nestedColRecord);
        }
        return record;
    }

    public static GenericRecord getRecordWithExampleSchemaWithoutNestedCol() {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA_WITHOUT_NESTED_COL));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("int_col", (Object)10);
        record.put("long_col", (Object)100L);
        return record;
    }
}

