/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.config.ProtoClassBasedSchemaProviderConfig;
import org.apache.hudi.utilities.schema.ProtoClassBasedSchemaProvider;
import org.apache.hudi.utilities.test.proto.Parent;
import org.apache.hudi.utilities.test.proto.Sample;
import org.apache.hudi.utilities.test.proto.WithOneOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtoClassBasedSchemaProvider {
    @Test
    public void validateDefaultSchemaGeneration() throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), Sample.class.getName());
        ProtoClassBasedSchemaProvider protoToAvroSchemaProvider = new ProtoClassBasedSchemaProvider(properties, null);
        Schema convertedSchema = protoToAvroSchemaProvider.getSourceSchema();
        Schema.Parser parser = new Schema.Parser();
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_defaults.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)convertedSchema);
    }

    @Test
    public void validateWrappedPrimitiveAndTimestampsAsRecordSchemaGeneration() throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), Sample.class.getName());
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS.key(), "true");
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS.key(), "true");
        ProtoClassBasedSchemaProvider protoToAvroSchemaProvider = new ProtoClassBasedSchemaProvider(properties, null);
        Schema convertedSchema = protoToAvroSchemaProvider.getSourceSchema();
        Schema.Parser parser = new Schema.Parser();
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_wrapped_and_timestamp_as_record.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)convertedSchema);
    }

    @Test
    public void validateRecursiveSchemaGeneration_depth2() throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), Parent.class.getName());
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_MAX_RECURSION_DEPTH.key(), String.valueOf(2));
        ProtoClassBasedSchemaProvider protoToAvroSchemaProvider = new ProtoClassBasedSchemaProvider(properties, null);
        Schema convertedSchema = protoToAvroSchemaProvider.getSourceSchema();
        Schema.Parser parser = new Schema.Parser();
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/parent_schema_recursive_depth_2.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)convertedSchema);
    }

    @Test
    public void validateRecursiveSchemaGeneration_defaultDepth() throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), Parent.class.getName());
        ProtoClassBasedSchemaProvider protoToAvroSchemaProvider = new ProtoClassBasedSchemaProvider(properties, null);
        Schema convertedSchema = protoToAvroSchemaProvider.getSourceSchema();
        Schema.Parser parser = new Schema.Parser();
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/parent_schema_recursive_default_limit.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)convertedSchema);
    }

    @Test
    public void validateOneOfSchemaGeneration() throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), WithOneOf.class.getName());
        ProtoClassBasedSchemaProvider protoToAvroSchemaProvider = new ProtoClassBasedSchemaProvider(properties, null);
        Schema protoSchema = protoToAvroSchemaProvider.getSourceSchema();
        Schema.Parser parser = new Schema.Parser();
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/oneof_schema.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)protoSchema);
    }
}

