/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestSchemaRegistryProvider {
    private static final String BASIC_AUTH = "foo:bar";
    private static final String REGISTRY_RESPONSE = "{\"schema\":\"{\\\"type\\\": \\\"record\\\", \\\"namespace\\\": \\\"example\\\", \\\"name\\\": \\\"FullName\\\",\\\"fields\\\": [{ \\\"name\\\": \\\"first\\\", \\\"type\\\": \\\"string\\\" }]}\"}";
    private static final String RAW_SCHEMA = "{\"type\": \"record\", \"namespace\": \"example\", \"name\": \"FullName\",\"fields\": [{ \"name\": \"first\", \"type\": \"string\" }]}";
    private static final String CONVERTED_SCHEMA = "{\"type\": \"record\", \"namespace\": \"com.example.hoodie\", \"name\": \"FullName\",\"fields\": [{ \"name\": \"first\", \"type\": \"string\" }]}";

    TestSchemaRegistryProvider() {
    }

    private static Schema getExpectedSchema() {
        return new Schema.Parser().parse(RAW_SCHEMA);
    }

    private static Schema getExpectedConvertedSchema() {
        return new Schema.Parser().parse(CONVERTED_SCHEMA);
    }

    private static TypedProperties getProps() {
        return new TypedProperties(){
            {
                this.put("hoodie.streamer.schemaprovider.registry.baseUrl", "http://foo:bar@localhost");
                this.put("hoodie.streamer.schemaprovider.registry.urlSuffix", "-value");
                this.put("hoodie.streamer.schemaprovider.registry.url", "http://foo:bar@localhost");
                this.put("hoodie.streamer.source.kafka.topic", "foo");
            }
        };
    }

    private static SchemaRegistryProvider getUnderTest(TypedProperties props) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(StringUtils.getUTF8Bytes((String)REGISTRY_RESPONSE));
        SchemaRegistryProvider spyUnderTest = (SchemaRegistryProvider)Mockito.spy((Object)new SchemaRegistryProvider(props, null));
        ((SchemaRegistryProvider)Mockito.doReturn((Object)is).when((Object)spyUnderTest)).getStream((HttpURLConnection)Mockito.any());
        return spyUnderTest;
    }

    @Test
    public void testGetSourceSchemaShouldRequestSchemaWithCreds() throws IOException {
        SchemaRegistryProvider spyUnderTest = TestSchemaRegistryProvider.getUnderTest(TestSchemaRegistryProvider.getProps());
        Schema actual = spyUnderTest.getSourceSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedSchema(), (Object)actual);
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)1))).setAuthorizationHeader((String)ArgumentMatchers.eq((Object)BASIC_AUTH), (HttpURLConnection)Mockito.any(HttpURLConnection.class));
    }

    @Test
    public void testGetTargetSchemaShouldRequestSchemaWithCreds() throws IOException {
        SchemaRegistryProvider spyUnderTest = TestSchemaRegistryProvider.getUnderTest(TestSchemaRegistryProvider.getProps());
        Schema actual = spyUnderTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedSchema(), (Object)actual);
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)1))).setAuthorizationHeader((String)ArgumentMatchers.eq((Object)BASIC_AUTH), (HttpURLConnection)Mockito.any(HttpURLConnection.class));
    }

    @Test
    public void testGetSourceSchemaShouldRequestSchemaWithoutCreds() throws IOException {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.streamer.schemaprovider.registry.url", (Object)"http://localhost");
        props.put((Object)"hoodie.streamer.schemaprovider.registry.schemaconverter", (Object)DummySchemaConverter.class.getName());
        SchemaRegistryProvider spyUnderTest = TestSchemaRegistryProvider.getUnderTest(props);
        Schema actual = spyUnderTest.getSourceSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)0))).setAuthorizationHeader((String)Mockito.any(), (HttpURLConnection)Mockito.any());
    }

    @Test
    public void testGetTargetSchemaShouldRequestSchemaWithoutCreds() throws IOException {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.streamer.schemaprovider.registry.url", (Object)"http://localhost");
        props.put((Object)"hoodie.streamer.schemaprovider.registry.schemaconverter", (Object)DummySchemaConverter.class.getName());
        SchemaRegistryProvider spyUnderTest = TestSchemaRegistryProvider.getUnderTest(props);
        Schema actual = spyUnderTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)0))).setAuthorizationHeader((String)Mockito.any(), (HttpURLConnection)Mockito.any());
    }

    @Test
    public void testGetSourceSchemaUsesCachedSchema() throws IOException {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        SchemaRegistryProvider spyUnderTest = TestSchemaRegistryProvider.getUnderTest(props);
        Schema actual = spyUnderTest.getSourceSchema();
        Assertions.assertNotNull((Object)actual);
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)1))).parseSchemaFromRegistry((String)Mockito.any());
        assert (spyUnderTest.cachedSourceSchema != null);
        Schema actualTwo = spyUnderTest.getSourceSchema();
        ((SchemaRegistryProvider)Mockito.verify((Object)spyUnderTest, (VerificationMode)Mockito.times((int)1))).parseSchemaFromRegistry((String)Mockito.any());
    }

    public static class DummySchemaConverter
    implements SchemaRegistryProvider.SchemaConverter {
        public String convert(String schema) throws IOException {
            return ((ObjectNode)new ObjectMapper().readTree(schema)).set("namespace", (JsonNode)TextNode.valueOf((String)"com.example.hoodie")).toString();
        }
    }
}

